package com.zl.sdk;

import android.annotation.SuppressLint;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.widget.RemoteViews;

import com.zl.sdk.ad.topOn.TopOnAdManager;
import com.zl.sdk.bean.AdAppInfo;
import com.zl.sdk.icon.IcOptManager;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.out.ActionFrom;
import com.zl.sdk.out.DialogShowStatusCallback;
import com.zl.sdk.out.OutAdManager;
import com.zl.sdk.util.LogUtil;
import com.zl.sdk.util.log.LogToLogcat;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Timer;
import java.util.TimerTask;

public final class OutHelp implements KPListener {
    private OutHelp() {
    }

    private static class Holder {
        @SuppressLint("StaticFieldLeak")
        private static final OutHelp INSTANCE = new OutHelp();
    }

    public static OutHelp get() {
        return OutHelp.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow OutHelp ---> ";
    private Context mContext = null;
    private boolean isDebug = false;
    private String sdkName = null;

    private String activityName = null;

    //是否第一次轮询
    private boolean firstLx = true;


    /**
     * 初始化
     *
     * @param context 上下文
     * @param isDebug 开启调试
     * @param isDebug appId
     * @param isDebug appKey
     */
    public void init(Context context, boolean isDebug, String appId, String appKey, String sdkName, String nameInterfacePath, String activityName) {
        this.mContext = context;
        this.isDebug = isDebug;
        this.sdkName = sdkName;
        this.activityName = activityName;

        LogUtil.d(TAG + "初始化 isDebug=" + isDebug);
        LogUtil.d(TAG + "初始化 appId=" + appId);
        LogUtil.d(TAG + "初始化 appKey=" + appKey);
        LogUtil.d(TAG + "初始化 sdkName=" + sdkName);
        LogUtil.d(TAG + "初始化 nameInterfacePath=" + nameInterfacePath);

        LogUtil.addObserver(new LogToLogcat());

        NameInterfaceHelp.setClassPath(nameInterfacePath);

        //初始化广告SDK
        AdAppInfo appInfo = new AdAppInfo(appId, appKey);
        TopOnAdManager.get().initSDK(context, appInfo);

        //Icon初始化
        IcOptManager.getInstance().init(context);
        IconHelp.get().init();

        //初始化触发条件
        initTriggerConditions();
    }

    private void initTriggerConditions() {
        initTimer();
        initReceiver();
    }

    private Timer timer;

    private void initTimer() {
        LogUtil.d(TAG + "初始化：initTimer");
        timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                LogUtil.d(TAG, "firstLx : " + firstLx);
                showOutAd(firstLx);
                if (firstLx) {
                    firstLx = false;
                }
            }
        }, 0, 60 * 1000);
    }

    private void initReceiver() {
        LogUtil.d(TAG + "初始化：initReceiver");
        TriggerReceiver triggerReceiver = new TriggerReceiver();
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction(Intent.ACTION_USER_PRESENT);
        intentfilter.addAction(Intent.ACTION_SCREEN_ON);
        intentfilter.addAction(Intent.ACTION_CLOSE_SYSTEM_DIALOGS);
        mContext.registerReceiver(triggerReceiver, intentfilter);
    }


    /**
     * 进入外展广告播放逻辑（解锁）
     *
     * @param actionFrom 动作来源
     */
    public void showOutAd(ActionFrom actionFrom) {
        LogUtil.d(TAG + "showOutAd（解锁）actionFrom=" + actionFrom);
        OutAdManager.get().startShowOutAd(actionFrom);
    }


    /**
     * 进入外展广告播放逻辑 （轮询）
     *
     * @param isFirst 是否第一次检查
     */
    private void showOutAd(boolean isFirst) {
        LogUtil.d(TAG + "showOutAd（轮询） isFirst=" + isFirst);
        OutAdManager.get().checkShowOutAd(isFirst);
    }


    public Context getContext() {
        return mContext;
    }


    public boolean isDebug() {
        return isDebug;
    }


    public String getSdkName() {
        return sdkName;
    }

    public String getActivityName() {
        return activityName;
    }


    public void clearNotification() {
        try {
            NotificationManager mNotificationManager = (NotificationManager) mContext.getSystemService(Context.NOTIFICATION_SERVICE);
            if (mNotificationManager != null) {
                mNotificationManager.cancelAll();
            }
        } catch (Exception e) {
        }
    }


    /**
     * 反射获取保活是否初始化
     */
    @Override
    public boolean isInit() {
        LogUtil.d(TAG + "获取保活 isInit");

        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method isInitMethod = kpClass.getMethod(NameInterfaceHelp.GetKPInitMethod);
            Object isInit = isInitMethod.invoke(null);
            if (isInit != null) {
                LogUtil.d(TAG + "获取保活： isInit=" + isInit);
                return (boolean) isInit;
            } else {
                LogUtil.d(TAG + "获取保活：(null) isInit=false");
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "获取保活：(catch) isInit=false");
            return false;
        }
    }


    /**
     * 反射获取icon状态
     */
    @Override
    public boolean iconIsHide() {
        LogUtil.d(TAG + "获取icon状态：iconIsHide");

        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method isHideMethod = kpClass.getMethod(NameInterfaceHelp.GetIconStateMethod);
            Object isHide = isHideMethod.invoke(null);
            if (isHide != null) {
                LogUtil.d(TAG + "获取icon状态： isHide=" + isHide);
                return (boolean) isHide;
            } else {
                LogUtil.d(TAG + "获取icon状态：(null) isHide=false");
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "获取icon状态：(catch) isHide=false");
            return false;
        }
    }


    /**
     * 反射获取应用是否在前台
     *
     * @return
     */
    @Override
    public boolean isAppForeground() {
        LogUtil.d(TAG + "获取前后台：isAppForeground");

        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method clsMethod = kpClass.getMethod(NameInterfaceHelp.GetAppRunForegroundMethod);
            Object isAppInFront = clsMethod.invoke(null);
            if (isAppInFront != null) {
                LogUtil.d(TAG + "获取前后台： isAppInFront=" + isAppInFront);
                return (boolean) isAppInFront;
            } else {
                LogUtil.d(TAG + "获取前后台：(null) isAppInFront=false");
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "获取前后台：(catch) isAppInFront=false");
            return false;
        }
    }


    /**
     * 反射调用保活拉起弹窗
     * 动态代理获取拉起结果的回调
     */
    @Override
    public void startOutDialog(Intent intent, DialogShowStatusCallback callback) {
        LogUtil.d(TAG + "拉起外展");

        try {
            String fgPath = NameInterfaceHelp.getFGClassPath();
            LogUtil.d(TAG + "拉起外展 fgPath=" + fgPath);

            Class<?> fgClass = Class.forName(fgPath);
            if (fgClass == null) {
                LogUtil.d(TAG + "拉起外展 fgClass=null");
                callback.fail("fgClass=null");
                return;
            }

            Class<?> startCallbackClass = Class.forName(NameInterfaceHelp.getStartCallbackClassPath());

            if (startCallbackClass == null) {
                LogUtil.d(TAG + "拉起外展 startCallbackClass=null");
                callback.fail("startCallbackClass=null");
                return;
            }

            Object callObj = NameInterfaceHelp.getNewCallBack();


            Class<?> notifyClass = Class.forName(NameInterfaceHelp.getNotificationConfigClassPath());
            Object notificationConfig = null;
            if (notifyClass != null) {
                Constructor constructor = notifyClass.getDeclaredConstructor(RemoteViews.class);
                notificationConfig = constructor.newInstance(new Object[]{null});

                //这个参数传0 就是不悬挂在桌面，1000 就是悬挂一秒，-1 就是持续悬挂
                Field[] fields = notifyClass.getDeclaredFields();
                for (Field field : fields) {
                    if (long.class.getName().equals(field.getName())) {
                        field.set(notificationConfig, 0);
                        break;
                    }
                }
            }

            Method surpriseMethod = fgClass.getMethod(NameInterfaceHelp.getFGStartMethodName(),
                    Context.class,
                    Intent.class,
                    String.class,
                    boolean.class,
                    startCallbackClass,
                    notifyClass);


            if (surpriseMethod == null) {
                LogUtil.d(TAG + "拉起外展 surpriseMethod=null");
                callback.fail("surpriseMethod=null");
                return;
            }


            Object newCallBack = Proxy.newProxyInstance(
                    startCallbackClass.getClassLoader(),
                    new Class[]{startCallbackClass},
                    new StartCallbackProxy(callObj, callback)
            );


            surpriseMethod.invoke(null, mContext, intent, "", true, newCallBack, notificationConfig);

        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException | InstantiationException e) {
            LogUtil.d(TAG + "拉起外展：(catch) fail=" + e.getMessage());
            if (callback != null) {
                callback.fail("执行失败");
            }
        }
    }


    @Override
    public void hideIcon() {
        LogUtil.d(TAG + "hideIcon");

        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method clsMethod = kpClass.getMethod(NameInterfaceHelp.HideIconMethod);
            clsMethod.invoke(null);
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException ignored) {
        }
    }


    @Override
    public void showIcon() {
        LogUtil.d(TAG + "showIcon");

        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method clsMethod = kpClass.getMethod(NameInterfaceHelp.ShowIconMethod);
            clsMethod.invoke(null);
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException ignored) {
        }
    }


    public static class StartCallbackProxy implements InvocationHandler {
        private final Object proxyObj;
        private final DialogShowStatusCallback callback;

        public StartCallbackProxy(Object obj, DialogShowStatusCallback callback) {
            this.proxyObj = obj;
            this.callback = callback;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (callback != null) {
                if ("onSuccess".equals(method.getName())) {
                    LogUtil.d(TAG + "拉起外展：onSuccess");
                    callback.success();
                } else if ("onFail".equals(method.getName())) {
                    LogUtil.d(TAG + "拉起外展：onFail");
                    if (objects.length >= 2) {
                        LogUtil.d(TAG + "拉起外展：onFail reason=" + objects[1]);
                        callback.fail((String) objects[1]);
                    } else {
                        LogUtil.d(TAG + "拉起外展：onFail reason=unknown");
                        callback.fail("unknown");
                    }
                }
            }
            return method.invoke(proxyObj, objects);
        }
    }

    public static class TriggerReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            switch (action) {
                case Intent.ACTION_USER_PRESENT: {
                    LogUtil.d(TAG + "===>>> 解锁");
                    OutHelp.get().showOutAd(ActionFrom.ACTION_USER_PRESENT);
                    break;
                }
                case Intent.ACTION_SCREEN_ON: {
                    LogUtil.d(TAG + "===>>> 亮屏");
                    break;
                }
                case Intent.ACTION_CLOSE_SYSTEM_DIALOGS: {
                    LogUtil.d(TAG + "===>>> 桌面");
                    break;
                }
                default: {
                }
            }
        }
    }

}