package com.zl.sdk.ad;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;

import com.anythink.interstitial.api.ATInterstitial;
import com.zl.sdk.OutHelp;
import com.zl.sdk.ad.interstitial.TopOnAdInterstitialCallBack;
import com.zl.sdk.ad.interstitial.TopOnInterstitialAdLoad;
import com.zl.sdk.bean.OutAdData;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.out.ActionFrom;
import com.zl.sdk.out.OutAdManager;
import com.zl.sdk.out.deepNightModle.DeepNight;
import com.zl.sdk.util.AppOutUtils;
import com.zl.sdk.util.LogUtil;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class TopOnAdLoadManager {
    public static final String TAG = "OutShow TopOnAdLoadManager";

    private TopOnAdLoadManager() {
        mContext = OutHelp.get().getContext();
    }

    private static final TopOnAdLoadManager INSTANCE = new TopOnAdLoadManager();

    public static TopOnAdLoadManager getInstance() {
        return INSTANCE;
    }


    public static final String REGISTER_TAG_WEATHER_PURE_AD = "PureAdDialog";
    private Context mContext;
    private final TopOnInterstitialAdLoad topOnInterstitialAdLoad = new TopOnInterstitialAdLoad();
    private final HashMap<String, WeakReference<OnInAdListener>> interstitialListenerHashMap = new HashMap<>();
    private final HashMap<String, Boolean> flagLoadMap = new HashMap<>();


    private Handler cleanActivityHandler = new Handler(Looper.getMainLooper());

    private TopOnAdInterstitialCallBack adInterstitialCallBack = new TopOnAdInterstitialCallBack() {

        @Override
        public void onAdLoaded(String adUnitId, String adScenes, OutAdData.NormalAdData adData, ATInterstitial ad) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdLoaded adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);

            callInterstitialAdLoaded();

            OutAdManager.get().cleanLoadAdFailTime();

            //只要有广告加载成功就去走播放逻辑
            //加载成功，调用播放纯广告逻辑
            LogUtil.d(TAG + "加载广告完成 去播放 doWork 222");
            OutAdManager.get().doWork(ActionFrom.ACTION_UNKNOWN, false);
        }

        @Override
        public void onAdDisplayed(String adUnitId, OutAdData.NormalAdData adData) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdDisplayed adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);

            callInterstitialAdShow();
            countAdShowTimes(adData);
            stateAfterShow(adData);

            //恢复设置
            OutHelp.get().setShowLock(false);

            //深夜模式，会自动关闭广告
            if (DeepNight.checkDeepNightRunning()) {
                long time = ((int) (Math.random() * 10) + 5) * 1000L;
                LogUtil.d("OutShow cleanAllActivity time =" + time);
                cleanActivityHandler.removeCallbacksAndMessages(null);
                cleanActivityHandler.postDelayed(() -> {
                    OutHelp.get().cleanAllActivity();
                }, time);
            }
        }

        @Override
        public void onAdHidden(String adUnitId) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdHidden adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);
            callInterstitialCloseAd();

        }

        @Override
        public void onAdClicked(String adUnitId) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdClicked adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);
            callInterstitialAdClk();

        }

        @Override
        public void onAdLoadFailed(String adUnitId, String errorMsg) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdLoadFailed adUnitId =" + adUnitId + ", Error=" + errorMsg);
            flagLoadMap.put(adUnitId, true);
            OutAdManager.get().showAdFail();
            callInterstitialNotAd(null == errorMsg ? "" : errorMsg);
        }

        @Override
        public void onAdDisplayFailed(String adUnitId, String errorMsg) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdDisplayFailed adUnitId =" + adUnitId + ", errorMsg=" + errorMsg);
            flagLoadMap.put(adUnitId, true);

            //恢复设置
            OutHelp.get().setShowLock(false);

            boolean isReady = topOnInterstitialAdLoad.isReady(adUnitId);
            if (isReady
                    && !TextUtils.isEmpty(errorMsg)
                    && (errorMsg.contains("ALREADY_SHOWING") || errorMsg.contains("Vungle is already playing different ad"))
            ) {
                statAfterShowError(showAdBean);
 /*               OutHelp.get().cleanAllActivity();
                LogUtil.d(TAG + "去播放 doWork 333");
                OutAdManager.get().doWork(ActionFrom.ACTION_UNKNOWN, false);*/
            } else {
                topOnInterstitialAdLoad.destroy(adUnitId);
                callInterstitialCloseAd();
            }
        }

        @Override
        public void onAdRevenuePaid(String adUnitId) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdRevenuePaid adUnitId =" + adUnitId);
        }

        @Override
        public void adVideoStart(String adUnitId) {
        }

        @Override
        public void adVideoEnd(String adUnitId) {
        }
    };

    private void stateAfterShow(OutAdData.NormalAdData adData) {
        try {
            boolean isReady = topOnInterstitialAdLoad.isReady(adData.cpAdslot);
            Map<String, Object> para = new HashMap<>();
            para.put("isReady", String.valueOf(isReady));
            Statistics.getInstance().dotEvent(mContext, "af_exp", "", para);
        } catch (Exception e) {
        }
    }

    private void statAfterShowError(AdBean adData) {
        try {
            boolean isReady = topOnInterstitialAdLoad.isReady(adData.getAdUnitId());
            Map<String, Object> para = new HashMap<>();
            para.put("isReady", String.valueOf(isReady));
            para.put("screen_state", String.valueOf(AppOutUtils.isScreenOn()));
            para.put("foreground", OutHelp.get().isAppForeground());
            para.put("time", Math.abs(System.currentTimeMillis() - OutHelp.get().getLastShowTime()));
            String adPage = OutHelp.get().getPage();
            if (!TextUtils.isEmpty(adPage)) {
                para.put("page", adPage);
            }
            Statistics.getInstance().dotEvent(mContext, "af_show_fail", "", para);
        } catch (Exception e) {
        }
    }

    public void loadInterstitialAd(OutAdData.NormalAdData normalAdData, String adScenes) {
        if (null == normalAdData || TextUtils.isEmpty(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "loadInterstitialAd data or adId empty");
            callInterstitialNotAd(AdErrorMessage.AD_DATA_IS_NULL_OR_NOT_ADUNITID);
            return;
        }

        if (topOnInterstitialAdLoad.isReady(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "loadInterstitialAd isReady");
            callInterstitialAdLoaded();
            return;
        }

        Boolean canLoadAd = flagLoadMap.get(normalAdData.cpAdslot);
        if (null != canLoadAd && !canLoadAd) {
            LogUtil.d(TAG, "loadInterstitialAd canLoadAd loading");
            return;
        }

        String adType = normalAdData.cpAdtype;
        if (TextUtils.isEmpty(adType)) {
            LogUtil.d(TAG, "loadInterstitialAd adType empty");
            callInterstitialNotAd(AdErrorMessage.NOT_ADTYPE);
            return;
        }

        String cpName = normalAdData.cpName;
        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG, "loadInterstitialAd cpName empty");
            callInterstitialNotAd(AdErrorMessage.NOT_AD_CP);
            return;
        }
        if (!cpName.equalsIgnoreCase(OutAdData.CP_AD_TOPON)) {
            LogUtil.d(TAG, "loadInterstitialAd adCp not support");
            callInterstitialNotAd(AdErrorMessage.AD_CP_NOT_SUPPORT);
            return;
        }

        flagLoadMap.put(normalAdData.cpAdslot, false);

        try {
            AdBean adBean = AdBean.getInstance(adScenes)
                    .setAdUnitId(normalAdData.cpAdslot)
                    .setAdPosition("out")
                    .setAdData(normalAdData);
            topOnInterstitialAdLoad.loadInterstitialAd(adBean, adInterstitialCallBack);
        } catch (Exception e) {
            flagLoadMap.put(normalAdData.cpAdslot, true);
            callInterstitialNotAd(e.toString());
        }
    }

    public void showInterstitialAd(Activity activity, AdBean adBean) {
        LogUtil.d(TAG, "showInterstitialAd really");
        topOnInterstitialAdLoad.showInterstitialAd(activity, adBean);
    }

    public boolean isInterstitialReady(String cpName, String adUnitId) {
        if (TextUtils.isEmpty(cpName) || TextUtils.isEmpty(adUnitId)) {
            LogUtil.d(TAG, "isInterstitialReady data empty");
            return false;
        }
        if (!cpName.equalsIgnoreCase(OutAdData.CP_AD_TOPON)) {
            LogUtil.d(TAG, "isInterstitialReady no ad");
            return false;
        }
        if (!topOnInterstitialAdLoad.isReady(adUnitId)) {
            LogUtil.d(TAG, "isInterstitialReady no ready");
            return false;
        }
        return true;
    }

    private AdBean showAdBean = null;

    public void showInterstitialAd(Activity activity, OutAdData.NormalAdData normalAdData, String adScenes) {
        if (null == normalAdData || TextUtils.isEmpty(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "showInterstitialAd data or adId empty");
            callInterstitialNotAd(AdErrorMessage.AD_DATA_IS_NULL_OR_NOT_ADUNITID);
            return;
        }

//        String adType = normalAdData.cpAdtype;
//        if (TextUtils.isEmpty(adType)) {
//            LogUtil.d(TAG, "showInterstitialAd adType empty");
//            callInterstitialNotAd(AdErrorMessage.NOT_ADTYPE);
//            return;
//        }

        String cpName = normalAdData.cpName;
        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG, "showInterstitialAd cpName empty");
            callInterstitialNotAd(AdErrorMessage.NOT_AD_CP);
            return;
        }

        if (!cpName.equalsIgnoreCase(OutAdData.CP_AD_TOPON)) {
            LogUtil.d(TAG, "showInterstitialAd adCp not support");
            callInterstitialNotAd(AdErrorMessage.AD_CP_NOT_SUPPORT);
            return;
        }

        if (!topOnInterstitialAdLoad.isReady(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "showInterstitialAd ad no Ready");
            callInterstitialNotAd(AdErrorMessage.AD_NOT_CACHE);
            return;
        }

        AdBean adBean = AdBean.getInstance(adScenes).setAdUnitId(normalAdData.cpAdslot)
                .setAdPosition("out")
                .setAdData(normalAdData);

        showAdBean = adBean;
        showInterstitialAd(activity, adBean);

        Map<String, Object> para = new HashMap<>();
        para.put("ad_scenes", adScenes);
        para.put("ad_type", "interstitial");
        para.put("adUnitId", normalAdData.cpAdslot);
        Statistics.getInstance().onEvent(mContext, EventUtils.LOAD_CACHE_AD, "", para);
    }

    private void callInterstitialNotAd(String errorMessage) {
        callNotAd(interstitialListenerHashMap, errorMessage);
    }

    private void callNotAd(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap, String errorMessage) {
        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onNotAd(errorMessage);
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    private void callInterstitialAdLoaded() {
        callAdLoaded(interstitialListenerHashMap);
    }

    private void callAdLoaded(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap) {
        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onLoadAd();
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    private void callInterstitialAdShow() {
        callAdShow(interstitialListenerHashMap);
    }

    private void callAdShow(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap) {
        LogUtil.d("OutShow 重置最后展示时间");
        OutHelp.get().setLastShowTime();

        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onShow();
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    private void callInterstitialCloseAd() {
        callCloseAd(interstitialListenerHashMap);
    }

    private void callCloseAd(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap) {
        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onCloseAd();
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }

        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }

        adClosed();
    }

    private void callInterstitialAdClk() {
        callAdClk(interstitialListenerHashMap);
    }

    private void callAdClk(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap) {
        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onClk();
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    public void registerCallBack(String adType, String tag, OnInAdListener onInAdListener) {
        if (TextUtils.isEmpty(adType)) {
            return;
        }

        registerInterstitialCallBack(tag, onInAdListener);
    }

    public void unregisterCallBack(String adType, String tag) {
        if (TextUtils.isEmpty(adType)) {
            return;
        }
        unregisterInterstitialCallBack(tag);
    }

    public void registerInterstitialCallBack(String tag, OnInAdListener onInAdListener) {
        LogUtil.d(TAG, "registerInterstitialCallBack tag =" + tag);
        registerCallBack(interstitialListenerHashMap, tag, onInAdListener);
    }

    public void registerCallBack(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap, String tag, OnInAdListener onInAdListener) {
        if (TextUtils.isEmpty(tag)) {
            return;
        }
        if (onInAdListener != null) {
            WeakReference<OnInAdListener> reference = new WeakReference<OnInAdListener>(onInAdListener);
            if (listenerHashMap.isEmpty()) {
                LogUtil.d(TAG, "registerCallBack tag =" + tag);
                listenerHashMap.put(tag, reference);
                return;
            }
            WeakReference<OnInAdListener> oldReference = listenerHashMap.get(tag);
            if (oldReference != null) {
                OnInAdListener adListener = oldReference.get();
                if (adListener != null && adListener.equals(onInAdListener)) {
                    return;
                }
            }
            listenerHashMap.put(tag, reference);
            LogUtil.d(TAG, "registerCallBack add tag =" + tag);
        }
    }

    public void unregisterInterstitialCallBack(String tag) {
        LogUtil.d(TAG, "unregisterInterstitialCallBack tag =" + tag);
        unregisterCallBack(interstitialListenerHashMap, tag);
    }

    private void unregisterCallBack(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap, String tag) {
        if (TextUtils.isEmpty(tag)) {
            return;
        }
        listenerHashMap.remove(tag);
    }

    private void countAdShowTimes(OutAdData.NormalAdData adData) {
        LogUtil.d(TAG, "countAdShowTimes adData =" + adData);
        OutAdManager.get().showAdSuccess(adData);
    }

    private void adClosed() {
        LogUtil.d(TAG, "adClosed");
        OutAdManager.get().adClosed();
    }
}