package com.zl.sdk.out;

import android.app.Activity;
import android.content.Context;
import android.media.AudioManager;
import android.text.format.DateUtils;

import com.anythink.expressad.reward.player.ATRewardVideoActivity;
import com.applovin.adview.AppLovinFullscreenActivity;
import com.applovin.adview.AppLovinFullscreenThemedActivity;
import com.applovin.sdk.AppLovinWebViewActivity;
import com.blankj.utilcode.util.ActivityUtils;
import com.bytedance.sdk.openadsdk.activity.TTFullScreenExpressVideoActivity;
import com.bytedance.sdk.openadsdk.activity.TTFullScreenVideoActivity;
import com.bytedance.sdk.openadsdk.activity.TTInterstitialActivity;
import com.mbridge.msdk.reward.player.MBRewardVideoActivity;
import com.vungle.ads.internal.ui.VungleActivity;
import com.blankj.utilcode.util.NetworkUtils;
import com.zl.sdk.OutHelp;
import com.zl.sdk.bean.WeatherAdData;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.DialogFailReason;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.keeplive.KplvManager;
import com.zl.sdk.util.AppOutUtils;
import com.zl.sdk.util.LogUtil;

import java.util.Calendar;

import f.g.ajglwh.fdauef.cpaukw.FG;

public class CheckHelper {
    private static final String TAG = "OutShow CheckHelper --> ";

    /**
     * 检查当前场景是否能播放外展广告
     * 解锁/回到桌面 触发展示的外展广告
     */
    public static boolean checkAdCanShowByScene(int actionState) {
        boolean isInit = KplvManager.getInstance().isInit();
        if (!isInit) {
            LogUtil.d(TAG + "（场景检查）保活未初始化，不能展示");
            EventUtils.staDialogFail(DialogFailReason.NO_INIT, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

//TODO 放在外面判断

//        if (SLKManager.get().existAppOutActivities()) {
//            LogUtil.d(TAG + "（场景检查）存在外展弹窗，不能展示");
//            EventUtils.staDialogFail(DialogFailReason.EXIST_OUT, actionState, EventUtils.DIALOG_TYPE_AD);
//            return false;
//        }

        if (!NetworkUtils.isConnected()) {
            LogUtil.d(TAG + "（场景检查）网络未连接，不能展示");
            EventUtils.staDialogFail(DialogFailReason.NO_NET, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }


        if (FG.isAppInFront()) {
            LogUtil.d(TAG + "（场景检查）应用在前台，不能展示");
            EventUtils.staDialogFail(DialogFailReason.IS_FOREGROUND, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        if (!AppOutUtils.isScreenOn()) {
            LogUtil.d(TAG + "（场景检查）手机未亮屏，不能展示");
            EventUtils.staDialogFail(DialogFailReason.SCREEN_OFF, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        if (isTelephonyCalling()) {
            LogUtil.d(TAG + "（场景检查）通话中，不能展示");
            EventUtils.staDialogFail(DialogFailReason.CALLING, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        boolean isLock = AppOutUtils.isScreenLock();
        if (actionState != -1) {
            EventUtils.statDialogScreenLock(isLock, actionState, EventUtils.DIALOG_TYPE_AD);
        }

        if (isLock) {
            LogUtil.d(TAG + "（场景检查）锁屏中，不能展示");

            if (AppOutUtils.isKeyguardSecure() && actionState != -1) {
                EventUtils.statDialogLockSecure(actionState, EventUtils.DIALOG_TYPE_AD);
            }

            EventUtils.staDialogFail(DialogFailReason.LOCK, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        } else {
            LogUtil.d(TAG + "（场景检查）能展示");
            return true;
        }
    }

    public static boolean checkAdCanShowBySceneNoIcon(int actionState) {
        boolean isInit = KplvManager.getInstance().isInit();
        if (!isInit) {
            LogUtil.d(TAG + "（场景检查）保活未初始化，不能展示");
            EventUtils.staDialogFail(DialogFailReason.NO_INIT, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        if (!NetworkUtils.isConnected()) {
            LogUtil.d(TAG + "（场景检查）网络未连接，不能展示");
            EventUtils.staDialogFail(DialogFailReason.NO_NET, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        if (!AppOutUtils.isScreenOn()) {
            LogUtil.d(TAG + "（场景检查）手机未亮屏，不能展示");
            EventUtils.staDialogFail(DialogFailReason.SCREEN_OFF, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        if (isTelephonyCalling()) {
            LogUtil.d(TAG + "（场景检查）通话中，不能展示");
            EventUtils.staDialogFail(DialogFailReason.CALLING, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        if (AppOutUtils.isScreenLock()) {
            LogUtil.d(TAG + "（场景检查）锁屏中，不能展示");
            EventUtils.staDialogFail(DialogFailReason.LOCK, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        if (checkTopActivityIsAd() && KplvManager.getInstance().isAppFront()) {
            LogUtil.d(TAG + "（场景检查）广告播放中，不能展示");
            EventUtils.staDialogFail(DialogFailReason.AD_EXITS, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        LogUtil.d(TAG + "（场景检查）能展示");
        return true;
    }


    /**
     * 检查顶层activity是否是广告的页面
     *
     * @return
     */
    private static boolean checkTopActivityIsAd() {
        Activity topActivity = ActivityUtils.getTopActivity();
        if (topActivity != null) {
            return topActivity instanceof TTFullScreenVideoActivity
                    || topActivity instanceof TTFullScreenExpressVideoActivity
                    || topActivity instanceof TTInterstitialActivity
                    //applovin
                    || topActivity instanceof AppLovinFullscreenActivity
                    || topActivity instanceof AppLovinFullscreenThemedActivity
                    || topActivity instanceof AppLovinWebViewActivity
                    //TopOn
                    || topActivity instanceof ATRewardVideoActivity
                    //Vungle
                    || topActivity instanceof VungleActivity
                    //M
                    || topActivity instanceof MBRewardVideoActivity;
        }
        return false;
    }


    public static boolean isUserPhone() {
        return AppOutUtils.isScreenOn() && !AppOutUtils.isScreenLock();
    }


    /**
     * 检查广告能否播放
     * 广告次数检查 + 广告缓存检查
     *
     * @param data        广告数据
     * @param actionState 触发场景
     * @return
     */
    public static boolean checkCanShowAd(WeatherAdData.NormalAdData data, int actionState) {
        return checkCanShowAdByTimesFromAdData(data, actionState) && checkAdReady(data);
    }


    /**
     * 检查广告数据是否可以播放
     */
    public static boolean checkCanShowAdByTimesFromAdData(WeatherAdData.NormalAdData data, int actionState) {
        if (data == null) {
            LogUtil.d(TAG + "（次数检查）广告信息为空 不能播放");
            EventUtils.staDialogFail(DialogFailReason.NO_DATA, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        long curTime = System.currentTimeMillis();
        long lastShowTime = AppOutSP.getHomeLastShowTime();


        long showIntervalTime = Math.abs(curTime - lastShowTime);
        LogUtil.d(TAG + "（次数检查）上次展示时间=" + lastShowTime);

        long spaceTime;

        if (IconHelp.get().isIconHided()) {
            spaceTime = data.intervalHide * DateUtils.SECOND_IN_MILLIS;
            LogUtil.d(TAG + "（次数检查）间隔时间（icon隐藏）=" + spaceTime);
        } else {
            spaceTime = data.interval * DateUtils.SECOND_IN_MILLIS;
            LogUtil.d(TAG + "（次数检查）间隔时间（icon未隐藏）=" + spaceTime);
        }


        if (showIntervalTime < spaceTime) {
            LogUtil.d(TAG + "（次数检查）未到间隔时间 不能播放");
            EventUtils.staDialogFail(DialogFailReason.INTERVAL_TIME, actionState, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        int homeNativeAdDayShowCount = AppOutSP.getHomeNativeAdDayShowCount();
        int homeInterstitialAdDayShowCount = AppOutSP.getHomeInterstitialAdDayShowCount();
        int homeDayShowCount = homeNativeAdDayShowCount + homeInterstitialAdDayShowCount;

        if (!isSameDay(curTime, lastShowTime)) {
            homeDayShowCount = 0;
            homeNativeAdDayShowCount = 0;
            homeInterstitialAdDayShowCount = 0;
            AppOutSP.saveHomeNativeAdDayShowCount(0);
            AppOutSP.saveHomeInterstitialAdDayShowCount(0);
        }

        if (IconHelp.get().isIconHided()) {
            if (homeDayShowCount >= data.showTimeHide) {
                LogUtil.d(TAG + "（次数检查）总次数 （icon隐藏） 超过播放次数");
                LogUtil.d(TAG + "（次数检查）总次数 （icon隐藏） 当前次数=" + homeDayShowCount);
                LogUtil.d(TAG + "（次数检查）总次数 （icon隐藏） 配置次数=" + data.showTimeHide);
                EventUtils.staDialogFail(DialogFailReason.COUNT_EXCEEDS, actionState, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        } else {
            if (homeDayShowCount >= data.showCount) {
                LogUtil.d(TAG + "（次数检查）总次数 （icon未隐藏） 超过播放次数");
                LogUtil.d(TAG + "（次数检查）总次数 （icon未隐藏） 当前次数=" + homeDayShowCount);
                LogUtil.d(TAG + "（次数检查）总次数 （icon未隐藏） 配置次数=" + data.showCount);
                EventUtils.staDialogFail(DialogFailReason.COUNT_EXCEEDS, actionState, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        }

        if (IconHelp.get().isIconHided()) {
            if (WeatherAdData.CP_AD_TYPE_NATIVE.equals(data.cpAdtype) && (homeNativeAdDayShowCount >= data.showTimesHideForAdId)) {
                LogUtil.d(TAG + "（次数检查）原生 （icon隐藏） 超过播放次数");
                LogUtil.d(TAG + "（次数检查）原生 （icon隐藏） 当前次数=" + homeNativeAdDayShowCount);
                LogUtil.d(TAG + "（次数检查）原生 （icon隐藏） 配置次数=" + data.showTimesHideForAdId);
                EventUtils.staDialogFail(DialogFailReason.NATIVE_EXCEEDS, actionState, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        } else {
            if (WeatherAdData.CP_AD_TYPE_NATIVE.equals(data.cpAdtype) && (homeNativeAdDayShowCount >= data.showTimes)) {
                LogUtil.d(TAG + "（次数检查）原生 （icon未隐藏） 超过播放次数");
                LogUtil.d(TAG + "（次数检查）原生 （icon未隐藏） 当前次数=" + homeNativeAdDayShowCount);
                LogUtil.d(TAG + "（次数检查）原生 （icon未隐藏） 配置次数=" + data.showTimes);
                EventUtils.staDialogFail(DialogFailReason.NATIVE_EXCEEDS, actionState, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        }

        if (IconHelp.get().isIconHided()) {
            if (WeatherAdData.CP_AD_TYPE_CHAPING.equals(data.cpAdtype) && (homeInterstitialAdDayShowCount >= data.showTimesHideForAdId)) {
                LogUtil.d(TAG + "（次数检查）插屏 （icon隐藏） 超过播放次数");
                LogUtil.d(TAG + "（次数检查）插屏 （icon隐藏） 当前次数=" + homeInterstitialAdDayShowCount);
                LogUtil.d(TAG + "（次数检查）插屏 （icon隐藏） 配置次数=" + data.showTimesHideForAdId);
                EventUtils.staDialogFail(DialogFailReason.CP_EXCEEDS, actionState, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        } else {
            if (WeatherAdData.CP_AD_TYPE_CHAPING.equals(data.cpAdtype) && (homeInterstitialAdDayShowCount >= data.showTimes)) {
                LogUtil.d(TAG + "（次数检查）插屏 （icon未隐藏） 超过播放次数");
                LogUtil.d(TAG + "（次数检查）插屏 （icon未隐藏） 当前次数=" + homeInterstitialAdDayShowCount);
                LogUtil.d(TAG + "（次数检查）插屏 （icon未隐藏） 配置次数=" + data.showTimes);
                EventUtils.staDialogFail(DialogFailReason.CP_EXCEEDS, actionState, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        }

        LogUtil.d(TAG + "（次数检查）可播放");
        return true;
    }

    public static boolean isSameDay(long time1, long time2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTimeInMillis(time1);
        cal2.setTimeInMillis(time2);
        return cal1.get(Calendar.YEAR) == cal2.get(Calendar.YEAR) &&
                cal1.get(Calendar.DAY_OF_YEAR) == cal2.get(Calendar.DAY_OF_YEAR);
    }


    /**
     * 检查广告是否准备好
     */
    public static boolean checkAdReady(WeatherAdData.NormalAdData data) {
        if (data == null) {
            return false;
        }
        boolean ready = false;
//        if (WeatherAdData.CP_AD_TYPE_CHAPING.equals(data.cpAdtype)) {
//            ready = TopOnAdLoadManager.getInstance().isInterstitialReady(data.cpName, data.cpAdslot);
//        } else if (WeatherAdData.CP_AD_TYPE_NATIVE.equals(data.cpAdtype)) {
//            ready = TopOnAdLoadManager.getInstance().isNativeReady(data.cpAdslot);
//        }
        LogUtil.d(TAG + "（缓存检查）是否有缓存：" + ready);
        return ready;
    }


    /**
     * 是否在通话中
     */
    public static boolean isTelephonyCalling() {
        Context context = OutHelp.get().getContext();
        AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        boolean calling = (audioManager.getMode() == AudioManager.MODE_IN_CALL
                || audioManager.getMode() == AudioManager.MODE_IN_COMMUNICATION);
        LogUtil.d("监听是否在通话中 Calling=" + calling);
        return calling;
    }
}