/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.or.ange.dot.encrpyt.C0008a;
import com.or.ange.dot.encrpyt.C0018k;
import com.or.ange.dot.encrpyt.C0024q;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;

@SuppressLint(value={"All"})
class Http {
    private static final String TAG = "Http";
    public static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static final int HTTP_TEMP_REDIRECT = 307;
    private static final int DEFAULT_TIMEOUT = 20000;

    private Http() {
        throw new UnsupportedOperationException();
    }

    public static HttpURLConnection head(String uri) throws IOException {
        return Http.head(uri, null);
    }

    public static HttpURLConnection head(String uri, Map<String, String> heads) throws IOException {
        URL url = new URL(uri);
        System.setProperty("http.keepAlive", "false");
        block5: while (true) {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            Http.setHttpsFactory(conn);
            conn.setConnectTimeout(20000);
            conn.setReadTimeout(20000);
            conn.setRequestMethod("HEAD");
            int responseCode = conn.getResponseCode();
            switch (responseCode) {
                case 200: 
                case 206: {
                    return conn;
                }
                case 416: {
                    throw new StopRequestException(416);
                }
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    String location = conn.getHeaderField("Location");
                    url = new URL(location);
                    continue block5;
                }
            }
            break;
        }
        return null;
    }

    private static void setHttpsFactory(HttpURLConnection conn) {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            httpsConn.setHostnameVerifier(new SkipHostnameVerifier());
            try {
                httpsConn.setSSLSocketFactory(Http.createSslSocketFactory());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static HttpURLConnection post(String uri) throws IOException {
        return Http.post(uri, null);
    }

    public static HttpURLConnection post(String uri, Map<String, String> heads) throws IOException {
        return Http.post(uri, heads, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpURLConnection post(String uri, Map<String, String> heads, Map<String, String> params, String body) throws IOException {
        URL url = params != null && params.size() > 0 ? new URL(uri + "?" + Http.convertRequestParamsToString(params)) : new URL(uri);
        OutputStream outputStream = null;
        block22: while (true) {
            HttpURLConnection httpURLConnection;
            try {
                Object m141a2;
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setAllowUserInteraction(false);
                conn.setConnectTimeout(20000);
                conn.setReadTimeout(20000);
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                Http.setHttpsFactory(conn);
                Http.addRequestHeaders(conn, heads);
                if (!TextUtils.isEmpty((CharSequence)body)) {
                    String m141a = C0024q.m141a(16);
                    m141a2 = C0024q.m141a(16);
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("a", (Object)C0018k.m172a((String)m141a2 + m141a));
                    jSONObject.put("b", (Object)C0008a.m207a(body, m141a, (String)m141a2));
                    outputStream = conn.getOutputStream();
                    outputStream.write(jSONObject.toString().getBytes("UTF-8"));
                    outputStream.flush();
                    outputStream.close();
                }
                int responseCode = conn.getResponseCode();
                switch (responseCode) {
                    case 200: 
                    case 206: {
                        m141a2 = conn;
                        return m141a2;
                    }
                    case 416: {
                        throw new StopRequestException(416);
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: {
                        String location = conn.getHeaderField("Location");
                        url = new URL(location);
                        continue block22;
                    }
                }
                httpURLConnection = null;
            }
            catch (Exception ex) {
                HttpURLConnection httpURLConnection2 = null;
                return httpURLConnection2;
            }
            finally {
                if (outputStream == null) continue;
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            return httpURLConnection;
            break;
        }
    }

    private static void addRequestHeaders(HttpURLConnection conn, Map<String, String> heads) {
        if (heads != null) {
            Set<Map.Entry<String, String>> headEntries = heads.entrySet();
            for (Map.Entry<String, String> entry : headEntries) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        conn.setRequestProperty("Accept-Encoding", "identity");
        conn.setRequestProperty("Accept-Encoding", "gzip");
    }

    public static String convertRequestParamsToString(Map<String, String> params) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(key, "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(value, "UTF-8"));
        }
        return result.toString();
    }

    private static SSLSocketFactory createSslSocketFactory() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new SkipX509TrustManager()}, new SecureRandom());
        return context.getSocketFactory();
    }

    public static class StopRequestException
    extends RuntimeException {
        private int code;

        public StopRequestException(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    private static class SkipHostnameVerifier
    implements HostnameVerifier {
        private SkipHostnameVerifier() {
        }

        @Override
        @SuppressLint(value={"BadHostnameVerifier"})
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    private static class SkipX509TrustManager
    implements X509TrustManager {
        private SkipX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }
}

