package com.zl.sdk.util.log;

import android.util.Log;

import com.zl.sdk.OutHelp;
import com.zl.sdk.util.LogUtil;

public abstract class AbsLog implements ILog {

    private static final String TAG = "AbsLog";
    public static final String GLOBAL_TAG = "weather";

    static {
        if (OutHelp.get().isDebug()) {
            LogUtil.wForce(TAG, "debug版本，" + GLOBAL_TAG + "，tag 开启日志");
        } else {
            LogUtil.wForce(TAG, "release版本，" + GLOBAL_TAG + "，tag 日志开关：" + Log.isLoggable(GLOBAL_TAG, Log.DEBUG));
        }
    }

    public static boolean isAllowProcessLog() {
        if (OutHelp.get().isDebug()) {
            return true;
        }
        //支持实时开启日志
        // adb shell  setprop log.tag.weather D
        return Log.isLoggable(GLOBAL_TAG, Log.DEBUG);
    }

    public void wForce(String msg) {
        wForce("", msg);
    }

    public void wForce(Throwable e) {
        wForce("", e);
    }

    public void eForce(Throwable e) {
        eForce("", e);
    }
}
