package com.zl.sdk.icon;

import android.text.TextUtils;

import com.zl.sdk.OutHelp;
import com.zl.sdk.bean.IconAdConfig;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.util.LogUtil;
import com.zl.sdk.util.SPUtils;

import org.json.JSONObject;

public class IconHelp {
    private IconHelp() {
    }

    private static class Holder {
        private static final IconHelp INSTANCE = new IconHelp();
    }

    public static IconHelp get() {
        return Holder.INSTANCE;
    }

    private static final String TAG = "IconHelp ---> ";

    //icon是否可见
    private volatile boolean iconHide = false;
    private volatile boolean kpInit = false;

    //重试间隔时间  默认20秒
    private long retryShowAdTime = 20 * 1000L;
    //重试次数  默认2次
    private int retryShowAdCount = 2;

    public long getRetryShowAdTime() {
        return retryShowAdTime;
    }

    public int getRetryShowAdCount() {
        return retryShowAdCount;
    }

    public void setRetryShowAdTime(long retryShowAdTime) {
        this.retryShowAdTime = retryShowAdTime;
    }

    public void setRetryShowAdCount(int retryShowAdCount) {
        this.retryShowAdCount = retryShowAdCount;
    }


    public void init() {
        iconHide = OutHelp.get().iconIsHide();
        LogUtil.d(TAG + "检查icon状态： iconHide=" + iconHide);

        if (iconHide) {
            iconHadHide();
        }
    }

    public boolean isIconHide() {
        return iconHide;
    }

    public boolean isKpInit() {
        return kpInit;
    }

    public void setKpInit(boolean kpInit) {
        this.kpInit = kpInit;
    }

    /**
     * icon状态变化
     */
    public void changeIconState(boolean isHide) {
        if (iconHide == isHide) {
            return;
        }

        iconHide = isHide;
        LogUtil.d(TAG + "检查icon状态：iconHide=" + iconHide);

        if (iconHide) {
            iconHadHide();
        }
    }

    private static void statIconHideUser() {
        try {
            Statistics.getInstance().dotEvent("hd_ic_start");
        } catch (Exception e) {
        }
    }

    private static final String PREF_FILE_NAME = "NetWeatherConfig";
    private static final String KEY_WEATHER_HIDE_SHOW_ICON_AD_CONFIG = "h_s_Icon_Ad_Config";

    private IconAdConfig getIconAdConfigObj() {
        IconAdConfig iconOpt = null;
        String json = SPUtils.getInstance(OutHelp.get().getContext(), PREF_FILE_NAME).getString(KEY_WEATHER_HIDE_SHOW_ICON_AD_CONFIG, "");
        if (TextUtils.isEmpty(json)) {
            return null;
        }

        try {
            JSONObject jsonObject = new JSONObject(json);
            iconOpt = new IconAdConfig();
            iconOpt.retry_interval_time = jsonObject.getInt("retry_interval_time");
            iconOpt.retry_times = jsonObject.getInt("retry_times");
        } catch (Exception e) {
        }

        LogUtil.d("get icon ad config:" + iconOpt);
        return iconOpt;
    }

    private void iconHadHide() {
        statIconHideUser();

        IconAdConfig adConfig = getIconAdConfigObj();
        if (adConfig != null) {
            IconHelp.get().setRetryShowAdCount(adConfig.retry_times);
            IconHelp.get().setRetryShowAdTime(adConfig.retry_interval_time * 1000L);
        }
    }
}