package com.zl.sdk;

import android.text.TextUtils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NameInterfaceHelp {
    private static String Class_Path = "";
    private static String FG_Class_Path = "";
    private static String FG_StartCallback_Class_Path = "";
    private static String FG_NotificationConfig_Class_Path = "";
    private static String FG_Start_Method_Name = "";

    public static String getClassPath() {
        return Class_Path;
    }

    public static void setClassPath(String class_Path) {
        Class_Path = class_Path;
    }

    /**
     * 保活FG类的路径
     */
    public static String getFGClassPath() {
        if (TextUtils.isEmpty(FG_Class_Path)) {
            try {
                Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
                Method isHideMethod = kpClass.getMethod(NameInterfaceHelp.GetFGStringMethod);
                Object fgStr = isHideMethod.invoke(null, "FG");
                if (fgStr == null) {
                    FG_Class_Path = "";
                } else {
                    FG_Class_Path = (String) fgStr;
                }
            } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                     IllegalAccessException ignored) {
            }
        }
        return FG_Class_Path;
    }

    /**
     * 保活FG类启动activity的方法名称
     */
    public static String getFGStartMethodName() {
        if (TextUtils.isEmpty(FG_Start_Method_Name)) {
            try {
                Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
                Method isHideMethod = kpClass.getMethod(NameInterfaceHelp.GetFGStringMethod);
                Object fgStr = isHideMethod.invoke(null, "surprise");
                if (fgStr == null) {
                    FG_Start_Method_Name = "";
                } else {
                    FG_Start_Method_Name = (String) fgStr;
                }
            } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                     IllegalAccessException ignored) {
            }
        }
        return FG_Start_Method_Name;
    }

    /**
     * 获取保活回调接口路径
     */
    public static String getStartCallbackClassPath() {
        if (TextUtils.isEmpty(FG_StartCallback_Class_Path)) {
            try {
                Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
                Method isHideMethod = kpClass.getMethod(NameInterfaceHelp.GetFGStringMethod);
                Object fgStr = isHideMethod.invoke(null, "StartCallback");
                if (fgStr == null) {
                    FG_StartCallback_Class_Path = "";
                } else {
                    FG_StartCallback_Class_Path = (String) fgStr;
                }
            } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                     IllegalAccessException ignored) {
            }
        }
        return FG_StartCallback_Class_Path;
    }

    /**
     * 获取保活NotificationConfig类的路径
     */
    public static String getNotificationConfigClassPath() {
        if (TextUtils.isEmpty(FG_StartCallback_Class_Path)) {
            try {
                Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
                Method isHideMethod = kpClass.getMethod(NameInterfaceHelp.GetFGStringMethod);
                Object fgStr = isHideMethod.invoke(null, "NotificationConfig");
                if (fgStr == null) {
                    FG_NotificationConfig_Class_Path = "";
                } else {
                    FG_NotificationConfig_Class_Path = (String) fgStr;
                }
            } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                     IllegalAccessException ignored) {
            }
        }
        return FG_NotificationConfig_Class_Path;
    }


    /**
     * 获取FG相关名称或路径的方法名称
     */
    public static String GetFGStringMethod = "getFName";


    /**
     * 获取保活方法的方法名称
     */
    public static String GetKPInitMethod = "isInit";

    /**
     * 获取icon状态的方法名称
     */
    public static String GetIconStateMethod = "iconIsHide";

    /**
     * 获取App是否在前台的方法名称
     */
    public static String GetAppRunForegroundMethod = "isAppForeground";

    /**
     * 隐藏icon的方法名称
     */
    public static String HideIconMethod = "hideIcon";

    /**
     * 显示icon的方法名称
     */
    public static String ShowIconMethod = "showIcon";
}
