package com.zl.sdk.keeplive;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;

import com.zl.sdk.OutHelp;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.util.LogUtil;

import java.util.HashMap;
import java.util.Map;

import f.g.ajglwh.fdauef.cpaukw.FG;
import f.g.ajglwh.fdauef.cpaukw.FgListener;

public class KplvManager {

    private static final String TAG = "FG_LOG";

    public static final String LAUNCHER_ACTIVITY_NAME = "com.global.weather.mvp.ui.view.launch.WelcomeActivity";

    private volatile boolean isInit = false;
    private volatile boolean isAttach = false;
    private Context context;

    @SuppressLint("StaticFieldLeak")
    private static KplvManager kplvManager;

    private KplvManager() {
    }

    public static synchronized KplvManager getInstance() {
        if (kplvManager == null) {
            kplvManager = new KplvManager();
        }
        return kplvManager;
    }

    public void attachBase(Context base) {
        if (isAttach) {
            return;
        }
        isAttach = true;
        try {
            FG.setUse_notification(false);
            FG.setUse_service(false);
            FG.setUse_domaemon(false);
            if (!FG.isMainProcess(base)) {
                FG.attach(base);
            }
        } catch (Throwable throwable) {
        }
    }

    public void checkInit(Context context, InitCallbak initCallbak) {
        if (this.context == null) {
            this.context = context.getApplicationContext();
        }
        checkNaturalUser(initCallbak);
    }

    private void statUsr(String state, String result, String sourceString) {
        Map<String, Object> params = new HashMap<>();
        params.put("state", state);
        if (!TextUtils.isEmpty(result)) {
            params.put("result", result);
        }
        if (!TextUtils.isEmpty(sourceString)) {
            params.put("source", sourceString);
        }

        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), "usr_check", "", params);
    }

    private void lvStat() {
        FG.setFGListener(new FgListener() {
            @Override
            public void onTrack(String eventName, Map<String, Object> map) {
                LogUtil.d("==FG==", "onTrack: " + eventName + " " + map.toString());
                try {
                    Statistics.getInstance().dotEvent(OutHelp.get().getContext(), eventName, "", map);
                } catch (Exception e) {
                }
            }

            @Override
            public void reportException(String message, Throwable e) {
            }

            @Override
            public void onBroadcastReceivedEvent(Intent intent) {
            }

            @Override
            public void onTiming() {
            }
        });
    }

    public void checkNaturalUser(InitCallbak initCallbak) {
        lvStat();
        if (initCallbak != null) {
            initCallbak.onFinish();
        }
    }


    private void init(Context context) {
        if (isInit) {
            return;
        }
        if (FG.isMainProcess(this.context)) {
            FG.setUse_music(false);
//            if (IconHelp.get().isIconHided()) {
            FG.setUSE_TA_ACTIVITY(true);
            FG.setUSE_BA_ACTIVITY(true);
//            }
            FG.setUSE_ShowWhenLocked(false);
            FG.setUse_thaw(false);
            if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.O || isLowMemory(context)) {
                LogUtil.dForce("==FG==", "低端机");
                FG.setUse_receiver(false);
            }
            //初始化
            FG.init(this.context, false);
            isInit = true;

            Statistics.getInstance().dotEvent(EventUtils.FG_INIT);
            LogUtil.d("==FG==", "fg init");
        }
    }

//    public void startActivity(Context context, Class targetActivityClass) {
//        if (FG.isAppInFront()) {
//            LogUtil.d(TAG, "在前台不进行弹出");
//            return;
//        }
//        Intent intent = new Intent(context, targetActivityClass);
//        startActivity(context, intent);
//    }
//
//    public void startActivity(Context context, Intent intent) {
//        SLKManager.get().resetIntent(intent);
//        LogUtil.d(TAG, "start intent :" + intent.toURI());
//        //TODO 事件上报
////        StatUtils.statRemindCommonFgSurpriseStart(StatUtils.WEATHER_START, "");
//
//        try {
//            FG.surprise(context, intent, "", false, new StartCallback() {
//                @Override
//                public void onSuccess(Intent intent) {
//                    LogUtil.d(TAG, "surprise onSuccess");
//                    try {
//                        //TODO 事件上报
////                        StatUtils.statRemindCommonFgSurpriseStart(StatUtils.WEATHER_START_OK, "");
//                    } catch (Throwable throwable) {
//                    }
//                }
//
//                @Override
//                public void onFail(Intent intent, String reason) {
//                    LogUtil.d(TAG, "surprise onFail reason =" + reason);
//                    try {
//                        //TODO 事件上报
////                        StatUtils.statRemindCommonFgSurpriseStart(StatUtils.WEATHER_START_NO, reason);
//                    } catch (Throwable throwable) {
//                    }
//                }
//
//                @Override
//                public void onNotificationShow(Intent intent) {
//                    //开始持续悬停
//                    LogUtil.d(TAG, "surprise onNotificationShow");
//                }
//
//                @Override
//                public void onNotificationClose(Intent intent, boolean isAuto) {
//                    //isAuto ： true 页面打开成功SDK自己关的 false：用户手动划掉或者任务栏清除通知被关
//                    LogUtil.d(TAG, "surprise onNotificationClose isAuto =" + isAuto);
//                }
//
//                @Override
//                public void onTry(Intent intent, int num) {
//                    LogUtil.d(TAG, "surprise onTry num =" + num);
//                }
//            }, null);
//        } catch (Exception e) {
//            //TODO 事件上报
////            StatUtils.statRemindCommonFgSurpriseStart(StatUtils.WEATHER_START_NO, e.toString());
//        }
//
//    }

    public boolean isInit() {
        return isInit;
    }

    public void hideIcon(Context context, String componentName) {
        FG.hideIcon(context, componentName);
    }

    public void showIcon(Context context, String componentName) {
        FG.showIcon(context, componentName);
    }

    public boolean isMainProcess(Context context) {
        return FG.isMainProcess(context);
    }

    public boolean isFGProcess(Context context) {
        return FG.isFgProcess(context);
    }

    public boolean isAppFront() {
        return FG.isAppInFront();
    }

    public void setShowOnLock(boolean showOnLock) {
        FG.setUSE_ShowWhenLocked(showOnLock);
    }

    private boolean isLowMemory(Context context) {
        ActivityManager manager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
        manager.getMemoryInfo(info);
        long total = info.totalMem;
        LogUtil.d(TAG, "isLowMemoryisLowMemory: " + total);
        if (total <= 1024 * 1024 * 1024 * 4L) {
            return true;
        }
        return false;
    }

    public boolean isIconHide(Context context, String launchName) {
        try {
            boolean isHide = FG.isHideIcon(context, launchName);
            return isHide;
        } catch (Throwable throwable) {
        }
        return false;
    }

    public interface InitCallbak {
        void onFinish();
    }
}
