package com.zl.sdk.ad;

import static com.zl.sdk.bean.WeatherAdData.CP_AD_TYPE_CHAPING;

import android.text.TextUtils;

import com.zl.sdk.bean.WeatherAdData;
import com.zl.sdk.util.LogUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AdDataManager {
    private AdDataManager() {
    }

    private static class Holder {
        private static final AdDataManager INSTANCE = new AdDataManager();
    }

    public static AdDataManager get() {
        return AdDataManager.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow AdDataManager --> ";

    private Map<Integer, ArrayList<WeatherAdData.NormalAdData>> adDataMap = new HashMap();

    public void setAdDataMap(Map<Integer, ArrayList<WeatherAdData.NormalAdData>> adDataMap) {
        this.adDataMap = adDataMap;
    }

    public ArrayList<WeatherAdData.NormalAdData> getOutAdData(int position, String cpName) {
        ArrayList<WeatherAdData.NormalAdData> cpNameList = new ArrayList<>();
        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG + "getOutAdData cpName empty");
            return cpNameList;
        }
        ArrayList<WeatherAdData.NormalAdData> list = adDataMap.get(position);
        if (list == null) {
            LogUtil.d(TAG, "getOutAdData list empty position =" + position);
            return cpNameList;
        }

        for (WeatherAdData.NormalAdData data : list) {
            LogUtil.d(TAG + "getOutAdData data.cpAdtype =" + data.cpAdtype + " ,cpName :" + cpName + ",,," + data.cpName);
            if (cpName.equalsIgnoreCase(data.cpName)) {
                //TODO 去掉原生数据
                if (CP_AD_TYPE_CHAPING.equals(data.cpAdtype)) {
                    cpNameList.add(data);
                }
            }
        }
        LogUtil.d(TAG, "getOutAdData list size =" + cpNameList.size());
        return cpNameList;
    }
}
