/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import com.or.ange.database.LikeModel;
import com.or.ange.database.LikePal;
import com.or.ange.dot.Event;
import com.or.ange.dot.Reporter;
import com.or.ange.dot.Settings;
import com.or.ange.dot.utils.LLog;
import java.io.Serializable;
import java.util.Map;
import org.json.JSONObject;

public final class UsageStats {
    private static final String TAG = "UsageStats";
    private static volatile boolean isInited = false;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context;
    private static String appId;
    private static String versionName;
    private static String versionCode;
    private static String dbName;
    private static String tableName;
    private static boolean oversea;

    private UsageStats() {
    }

    public static Settings initialize(Context context) {
        return UsageStats.initialize(context, null);
    }

    public static Settings initialize(Context context, String appId) {
        return UsageStats.initialize(context, appId, "", "");
    }

    public static Settings initialize(Context context, String appId, boolean oversea) {
        return UsageStats.initialize(context, appId, "", "", oversea);
    }

    public static Settings initialize(Context context, String appId, String db, String tableName) {
        return UsageStats.initialize(context, appId, db, tableName, false);
    }

    public static Settings initialize(Context context, String appId, String db, String tableName, boolean oversea) {
        if (!isInited) {
            if (context == null) {
                throw new NullPointerException("context is null");
            }
            UsageStats.context = context.getApplicationContext();
            UsageStats.appId = appId;
            dbName = TextUtils.isEmpty((CharSequence)db) ? "mmt" : db;
            UsageStats.tableName = tableName;
            versionName = UsageStats.getAppVersionName(context);
            versionCode = UsageStats.getAppVersionCode(context);
            UsageStats.oversea = oversea;
            String tn = TextUtils.isEmpty((CharSequence)tableName) ? "event" : tableName;
            UsageStats.getEventLikeModel().execSQL("CREATE TRIGGER IF NOT EXISTS trigger_event_insert AFTER INSERT ON [" + tn + "] WHEN (SELECT count(*) FROM " + tn + ") > 1000   BEGIN     DELETE FROM " + tn + " WHERE id NOT IN\n    (      SELECT id FROM " + tn + " ORDER BY ts DESC LIMIT 1000    );  END");
            isInited = true;
            LLog.i(TAG, "init Dot success.");
        } else {
            LLog.w(TAG, "init yet.");
        }
        return SettingsHolder.settings;
    }

    public static Settings settings() {
        UsageStats.checkInit();
        return SettingsHolder.settings;
    }

    private static void checkInit() {
        if (!isInited) {
            throw new IllegalStateException("\u5fc5\u987b\u5148\u8c03\u7528Dot.initialize()\u521d\u59cb\u5316\u5e93.");
        }
    }

    public static void onEvent(String eventId) {
        UsageStats.onEvent(eventId, "");
    }

    public static void onEvent(String eventId, String label) {
        UsageStats.onEvent(eventId, label, null);
    }

    public static <T extends Serializable> void onEvent(String eventId, Map<String, T> params) {
        UsageStats.onEvent(eventId, "", params);
    }

    public static <T extends Serializable> void onEvent(String eventId, String label, Map<String, T> params) {
        UsageStats.checkInit();
        if (TextUtils.isEmpty((CharSequence)eventId)) {
            LLog.w(TAG, "eventId is empty.");
            return;
        }
        Event event = new Event();
        event.setEventId(eventId);
        event.setLabel(TextUtils.isEmpty((CharSequence)label) ? context.getPackageName() : label);
        event.setVersionName(UsageStats.getVersionName());
        event.setVersionCode(UsageStats.getVersionCode());
        event.setTimestamp(System.currentTimeMillis());
        if (params != null) {
            JSONObject paramsObj = new JSONObject(params);
            event.setParams(paramsObj.toString());
        }
        LLog.d(TAG, "onEvent:" + event);
        Reporter.getInstance().reportEvent(event);
    }

    static Context getContext() {
        UsageStats.checkInit();
        return context;
    }

    static String getVersionName() {
        UsageStats.checkInit();
        return versionName;
    }

    static String getVersionCode() {
        UsageStats.checkInit();
        return versionCode;
    }

    public static String getAppId() {
        UsageStats.checkInit();
        return appId;
    }

    public static boolean isOversea() {
        UsageStats.checkInit();
        return oversea;
    }

    private static String getAppVersionName(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (pi != null) {
                return pi.versionName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "error:version";
    }

    private static String getAppVersionCode(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (pi != null) {
                return String.valueOf(pi.versionCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "-1";
    }

    static LikeModel<Event> getEventLikeModel() {
        return LikePal.getLikeModel(Event.class, (String)dbName, (String)tableName);
    }

    private static interface SettingsHolder {
        public static final Settings settings = new Settings();
    }
}

