/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot;

import android.text.TextUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Settings {
    private int maxCaches = 20;
    private long interval = 300000L;
    private String reportUrl;
    private final Set<String> immediate = new HashSet<String>();

    Settings() {
    }

    public Settings immediate(Collection<String> immediateEvents) {
        if (immediateEvents != null) {
            this.immediate.addAll(immediateEvents);
        }
        return this;
    }

    public Settings interval(long millis) {
        this.interval = Math.max(millis, 60000L);
        return this;
    }

    public Settings reportUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.reportUrl = url;
        }
        return this;
    }

    public Settings maxCaches(int maxCaches) {
        this.maxCaches = Math.max(maxCaches, 10);
        return this;
    }

    public int getMaxCaches() {
        return this.maxCaches;
    }

    public long getInterval() {
        return this.interval;
    }

    public String getReportUrl() {
        if (TextUtils.isEmpty((CharSequence)this.reportUrl)) {
            throw new RuntimeException("reportUrl is null");
        }
        return this.reportUrl;
    }

    public Set<String> getImmediate() {
        return this.immediate;
    }
}

