package com.zl.sdk.util.log;

import android.os.Environment;
import android.os.Process;

import com.blankj.utilcode.util.Utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;


public class LogToFile extends AbsLog {

    public static final String CALENDAR_PATH_FILE = "Ssui/calendar";
    private static final String BASE_FILENAME = ".log";
    private static final String PACKAGE_NAME = CALENDAR_PATH_FILE + "/Log";
    private static final String LOG_LINE_CONNECTOR = " : ";
    private static final String LOG_SEPARATOR = "   ";
    private static final int SIZE = 2048;
    private static String LOG_DIRECTORY;// = SDCardUtil.getSDCardPath();//StorageMgr.getInstance().getSdcardAppFilesAbsolutePath();
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String DAY_FORMAT = "yyyy-MM-dd";
    private boolean mIsOpen = false;
    private Writer mWriter;

    public LogToFile() {
        if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())
                && Utils.getApp().getExternalCacheDir() != null)
            LOG_DIRECTORY = Utils.getApp().getExternalCacheDir().getAbsolutePath();// + FILE_SEP + "log" + FILE_SEP;
        else {
            LOG_DIRECTORY = Utils.getApp().getCacheDir().getAbsolutePath();// + FILE_SEP + "log" + FILE_SEP;
        }
    }

    @Override
    public void w(String tag, String msg) {
//        println(tag, msg, "w");
    }

    @Override
    public void i(String tag, String msg) {
//        println(tag, msg, "i");
    }

    @Override
    public void v(String tag, String msg) {
//        println(tag, msg, "v");
    }

    @Override
    public void d(String tag, String msg) {
//        println(tag, msg, "d");
    }

    @Override
    public void e(String tag, String msg) {
//        println(tag, msg, "e");
    }

    @Override
    public void e(String tag, String msg, Throwable e) {
//        printStack(tag, msg, "e", e);
    }

    @Override
    public void e(String tag, Throwable e) {
//        printStack(tag, "", "e", e);
    }

    @Override
    public void dForce(String msg) {
//        println("", msg, "dForce");
    }

    @Override
    public void dForce(String tag, String msg) {
//        println(tag, msg, "dForce");
    }

    @Override
    public void wForce(String tag, String msg) {
//        println(tag, msg, "wForce");
    }

    @Override
    public void wForce(String tag, Throwable e) {
//        printStack(tag, "", "wForce", e);
    }

    @Override
    public void wForce(String tag, String msg, Throwable e) {
//        printStack(tag, msg, "wForce", e);
    }

    @Override
    public void eForce(String tag, String msg, Throwable e) {
//        printStack(tag, msg, "eForce", e);
    }

    @Override
    public void eForce(String tag, Throwable e) {
//        printStack(tag, "", "eForce", e);
    }

    @Override
    public void debugLog(Object debugLog) {
//        dForce("debugLog", String.valueOf(debugLog));
    }

    private static String getCurrentDate() {
        SimpleDateFormat dateFormat = (SimpleDateFormat) DateFormat.getDateInstance();
        dateFormat.applyPattern(DAY_FORMAT);
        return dateFormat.format(new Date());
    }

    private static String getCurrentTime() {
        SimpleDateFormat dateFormat = (SimpleDateFormat) DateFormat.getDateInstance();
        dateFormat.applyPattern(TIME_FORMAT);
        return dateFormat.format(new Date());
    }

    private static String getLogDirectory() {
        final StringBuffer buffer = new StringBuffer();
        buffer.append(LOG_DIRECTORY).append(File.separator).append(PACKAGE_NAME).append(File.separator)
                .append(getCurrentDate()).append(BASE_FILENAME);
        return buffer.toString();
    }

    private void open() throws Exception {
        File file = new File(getLogDirectory());
        if (!file.getParentFile().exists()) {
            try {
                file.getParentFile().mkdirs();
            } catch (Exception e) {
                throw new LogException("create log dirs error!" + e);
            }
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            } catch (IOException e) {
                throw new LogException("create log file error!" + e);
            }
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file, true),
                    "utf-8");
            mWriter = new BufferedWriter(writer, SIZE);
        } catch (IOException e) {
            throw new LogException("open log file error!");
        }
        mIsOpen = true;
    }

    private void writeLine(String message) {
        try {
            mWriter.append(message);
            mWriter.append('\n');
            mWriter.flush();
        } catch (Exception e) {
            throw new LogException();
        }
    }

    public void dispose() {
        if (mWriter != null) {
            try {
                mWriter.close();
            } catch (IOException e) {
                // ignore
            }
        }
    }

    private void println(String tag, String msg, String level) {
        if (!mIsOpen) {
            try {
                open();
            } catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        final StringBuffer buffer = new StringBuffer();
        buffer.append(getCurrentTime()).append(LOG_SEPARATOR).append(Process.myPid())
                .append(LOG_SEPARATOR).append(GLOBAL_TAG + "." + tag).append(LOG_SEPARATOR).append(level).append(LOG_LINE_CONNECTOR).append(msg);
        writeLine(buffer.toString());
    }

    public void printStack(String tag, String msg, String level, Throwable throwable) {
        if (!mIsOpen) {
            try {
                open();
            } catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        final StringBuffer buffer = new StringBuffer();
        buffer.append(getCurrentTime()).append(LOG_SEPARATOR).append(Process.myPid())
                .append(LOG_SEPARATOR).append(GLOBAL_TAG + "." + tag).append(LOG_SEPARATOR).append(level).append(LOG_LINE_CONNECTOR).append(msg);
        writeLine(buffer.toString());
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw, true);
            throwable.printStackTrace(pw);
            pw.flush();
            sw.flush();
            writeLine(tag + LOG_LINE_CONNECTOR + sw.toString());
        } catch (Exception e) {

        } finally {
            if (sw != null) {
                try {
                    sw.close();
                } catch (IOException e) {
                }
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

}
