package com.zl.sdk.event.statistics;

import android.content.Context;

import com.or.ange.database.LikePal;
import com.or.ange.dot.Settings;
import com.or.ange.dot.UsageStats;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class DotOperator extends AbsStatistics {

    public DotOperator(Context context) {
        LikePal.initialize(context);
        Settings settings = UsageStats.initialize(context, "20012", "", "aex", true);
        settings.reportUrl("https://weather-ssc.lkyxzb.com/weather-stat/v4");
    }

    @Override
    public void onResume(Context context) {
    }

    @Override
    public void onPause(Context context) {
    }

    @Override
    public void onPageStart(Context context, String pageName) {
    }

    @Override
    public void onPageEnd(Context context, String pageName) {
    }

    @Override
    public void onEvent(Context context, String eventId) {
        UsageStats.onEvent(eventId);
    }

    @Override
    public void onEvent(Context context, String eventId, String eventLabel) {
        try {
            UsageStats.onEvent(eventId, eventLabel);
        } catch (Exception e) {
        }
    }

    @Override
    public void onEvent(Context context, String eventId, String eventLabel, Map<String, Object> eventMap) {
        Map<String, String> map = new HashMap<>();
        if (eventMap != null) {
            for (String key : eventMap.keySet()) {
                Object value = eventMap.get(key);
                if (value != null) {
                    if (value instanceof String) {
                        map.put(key, (String) value);
                    } else {
                        try {
                            map.put(key, String.valueOf(value));
                        } catch (Exception ex) {
                        }
                    }
                }
            }
        }
        try {
            UsageStats.onEvent(eventId, eventLabel, map);
        } catch (Exception e) {
        }
    }

    @Override
    public void dotEvent(Context context, String eventId, String eventLabel, Map<String, Object> eventMap) {
        Map<String, String> map = new HashMap<>();
        if (eventMap != null) {
            for (String key : eventMap.keySet()) {
                Object value = eventMap.get(key);
                if (value != null) {
                    if (value instanceof String) {
                        map.put(key, (String) value);
                    } else {
                        try {
                            map.put(key, String.valueOf(value));
                        } catch (Exception ex) {
                        }
                    }
                }
            }
        }
        try {
            UsageStats.onEvent(eventId, eventLabel, map);
        } catch (Exception e) {
        }
    }

    @Override
    public void onError(Context context, Throwable throwable) {
    }

    public void onEvent(Context context, String eventId, Map<String, String> eventMap) {
        Map<String, String> map = new ConcurrentHashMap<>();
        if (eventMap != null) {
            for (String key : eventMap.keySet()) {
                Object value = eventMap.get(key);
                if (value != null && value instanceof String) {
                    map.put(key, (String) value);
                }
            }
        }
        try {
            UsageStats.onEvent(eventId, map);
        } catch (Exception e) {
        }
    }

    @Override
    public void dotEvent(String eventId) {
        try {
            UsageStats.onEvent(eventId);
        } catch (Exception e) {
        }
    }
}
