package com.zl.sdk.event;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

import com.zl.sdk.OutHelp;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.util.LogUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public final class EventUtils {
    public static final String OUT_AD_START = "out_ad_start";

    public static final String OUT_DIALOG_SCREEN_LOCK = "out_dialog_screen_lock";

    public static final String OUT_DIALOG_FAIL = "out_dialog_b_fail";

    public static final String OUT_DIALOG_HOME_TRRIGER = "out_dialog_home";

    public static final String OUT_DIALOG_LOCK_TRRIGER = "out_dialog_lock";
    public static final String OUT_DIALOG_LOCK_SECURE = "out_dialog_lock_secure";


    public static final String TOPON_LOAD_SUCCESS_BUT_CALLBACK_NULL = "topon_load_success_but_callback_null";//加載原生廣告成功但是返回廣告素材是空
    public static final String LOAD_CACHE_AD = "load_cache_ad";//加載緩存廣告
    public static final String HIDE_ICON = "hd_icon"; //隐藏icon
    public static final String FG_INIT = "lv_init"; //保活初始化

    public static final String SLK_START = "start";
    public static final String SLK_START_OK = "startOk";
    public static final String SLK_START_NO = "startNo";

    public static final String SLK_SW_CLOSE = "swClose";

    public static final String DIALOG_TYPE_AD = "ad";


    public static final String REMINDER_DIALOG_FG_SURPRISE_START = "reminder_dg_fg_surprise_start";

    //外展弹窗事件
    public static void staDialogFail(DialogFailReason reason, int actionState, String type) {
        Map<String, Object> map = new HashMap<>();
        map.put("reason", reason.name().toLowerCase());
        map.put("action", String.valueOf(actionState));
        map.put("type", type);
        map.put("hide", String.valueOf(IconHelp.get().isIconHided()));
        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), OUT_DIALOG_FAIL, "", map);
    }

    public static void statDialogScreenLock(boolean isLock, int actionState, String type) {
        Map<String, Object> map = new HashMap<>();
        map.put("isLock", isLock ? "1" : "0");
        map.put("action", String.valueOf(actionState));
        map.put("type", type);
        map.put("hide", String.valueOf(IconHelp.get().isIconHided()));
        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), OUT_DIALOG_SCREEN_LOCK, "", map);
    }

    public static void statDialogLockSecure(int actionState, String type) {
        Map<String, Object> map = new HashMap<>();
        map.put("action", String.valueOf(actionState));
        map.put("type", type);
        map.put("hide", String.valueOf(IconHelp.get().isIconHided()));
        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), OUT_DIALOG_LOCK_SECURE, "", map);
    }

    public static void stProcessHome(boolean isLock, int actionState) {
        Map<String, Object> map = new HashMap<>();
        map.put("isLock", isLock ? "1" : "0");
        map.put("action", String.valueOf(actionState));
        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), OUT_DIALOG_HOME_TRRIGER, "", map);
    }

    public static void stProcessLock(boolean isLock, int actionState) {
        Map<String, Object> map = new HashMap<>();
        map.put("isLock", isLock ? "1" : "0");
        map.put("action", String.valueOf(actionState));
        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), OUT_DIALOG_LOCK_TRRIGER, "", map);
    }


    //广告事件
    public static void statAdRequest(ReportBean bean) {
        if (bean == null) {
            return;
        }
        bean.eventid = AdsParamsInfo.F_REQUEST;
        statAdReport(bean);
    }

    public static void statAdLoaded(ReportBean bean, long requestTime) {
        if (bean == null) {
            return;
        }
        bean.eventid = AdsParamsInfo.F_AD_REQUEST_DURATION;
        bean.duration = System.currentTimeMillis() - requestTime;
        statAdReport(bean);
    }

    public static void statAdExpose(ReportBean bean) {
        if (bean == null) {
            return;
        }
        bean.eventid = AdsParamsInfo.F_EXPOSURE;
        statAdReport(bean);
    }

    public static void statAdClose(ReportBean bean) {
        if (bean == null) {
            return;
        }
        bean.eventid = AdsParamsInfo.F_CLOSE;
        statAdReport(bean);
    }

    public static void statAdClick(ReportBean bean) {
        if (bean == null) {
            return;
        }
        bean.eventid = AdsParamsInfo.F_CLICK;
        statAdReport(bean);
    }

    public static void statAdLoadFail(ReportBean bean, long requestTime) {
        if (bean == null) {
            return;
        }
        bean.eventid = AdsParamsInfo.F_FAILE;
        bean.duration = System.currentTimeMillis() - requestTime;
        statAdReport(bean);
    }

    public static void statDisplayFail(ReportBean bean) {
        if (bean == null) {
            return;
        }
        bean.eventid = AdsParamsInfo.F_SHOW_FILE;
        statAdReport(bean);
    }

    public static void statAdPaidEven(ReportBean bean, long requestTime) {
        if (bean == null) {
            return;
        }
        bean.eventid = AdsParamsInfo.F_AD_PAIDEVENT;
        bean.duration = System.currentTimeMillis() - requestTime;
        statAdReport(bean);
    }

    public static void statAdExpired(ReportBean bean) {
        if (null == bean) {
            return;
        }
        bean.eventid = AdsParamsInfo.AD_EXPIRED;
        statAdReport(bean);
    }

    //外展弹窗拉起状态 事件上报
    public static void statRemindOutFgSurpriseStart(String state, String exception, boolean isAdReady, int actionState) {
        Map<String, Object> map = new HashMap<>();
        map.put("state", state);
        map.put("type", "out");
        map.put("reason", exception);
        map.put("os", getOSVersion());
        map.put("hide", String.valueOf(IconHelp.get().isIconHided()));
        map.put("osLevel", String.valueOf(getSdkInt()));
        map.put("ad_ready", false);
        map.put("ad_action", String.valueOf(isAdReady));
        map.put("action", String.valueOf(actionState));
        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), REMINDER_DIALOG_FG_SURPRISE_START, "", map);
    }

    //轮询外展广告
    public static void statTimeTriggle() {
        Map<String, Object> map = new HashMap<>();
        map.put("type", String.valueOf(IconHelp.get().isIconHided()));
//        map.put("init", String.valueOf(KplvManager.getInstance().isInit()));
        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), "time_trig", "", map);
    }


    private static String getOSVersion() {
        try {
            return Build.VERSION.RELEASE; // android系统版本号
        } catch (Exception e) {
        }
        return "";
    }

    private static int getSdkInt() {
        try {
            return Build.VERSION.SDK_INT;
        } catch (Exception e) {
        }
        return -1;
    }


    public static void statAdReport(ReportBean bean) {
        try {
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put(AdsParamsInfo.ADUNITID, bean.adUnitId);
            hashMap.put(AdsParamsInfo.ADPISTION, bean.ad_position);
            hashMap.put(AdsParamsInfo.ADTYPE, bean.adtype);
            hashMap.put(AdsParamsInfo.DURATION, String.valueOf(bean.duration));
            hashMap.put(AdsParamsInfo.AD_PRECISION, String.valueOf(bean.precision));
            hashMap.put(AdsParamsInfo.AD_CURRENCYCode, bean.currencyCode);
            hashMap.put(AdsParamsInfo.AD_VALUEMICROS, String.valueOf(bean.valueMicros));
            hashMap.put(AdsParamsInfo.AD_SCENES, bean.ad_scenes);
            hashMap.put("hide", String.valueOf(IconHelp.get().isIconHided()));
            if (!TextUtils.isEmpty(bean.eventid)) {
                if (!bean.eventid.equals(AdsParamsInfo.F_REQUEST)) {
                    hashMap.put(AdsParamsInfo.SOURCE, bean.source);
                    hashMap.put(AdsParamsInfo.ISBIDDING, String.valueOf(bean.isbidding));
                }
                if (bean.eventid.equals(AdsParamsInfo.F_CLICK) || bean.eventid.equals(AdsParamsInfo.F_CLOSE) || bean.eventid.equals(AdsParamsInfo.F_FAILE) || bean.eventid.equals(AdsParamsInfo.F_OPEN) || bean.eventid.equals(AdsParamsInfo.F_SHOW_FILE)) {
                    hashMap.put(AdsParamsInfo.TIME, String.valueOf(bean.time));
                    if (bean.eventid.equals(AdsParamsInfo.F_FAILE) || bean.eventid.equals(AdsParamsInfo.F_SHOW_FILE)) {
                        hashMap.put(AdsParamsInfo.AD_MSG_EEROR, bean.ad_msg_error);
                    }
                }
            }
            if (null != bean.ad_response && !TextUtils.isEmpty(bean.ad_response)) {
                try {
                    hashMap.put(AdsParamsInfo.AD_RESPONE, new JSONObject(bean.ad_response).toString());
                } catch (JSONException e) {
                    hashMap.put(AdsParamsInfo.AD_RESPONE, bean.ad_response);
                }
            }
            Statistics.getInstance().onEvent(OutHelp.get().getContext(), bean.eventid, hashMap);
        } catch (Exception e) {
            LogUtil.e("AppOutStatUtils", "statAdReport e :" + Log.getStackTraceString(e));
        }
    }
}