package com.zl.sdk;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import androidx.annotation.Keep;

import com.blankj.utilcode.util.AppUtils;
import com.zl.sdk.ad.topOn.TopOnAdManager;
import com.zl.sdk.bean.AdAppInfo;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.out.ActionFrom;
import com.zl.sdk.out.DialogShowStatusCallback;
import com.zl.sdk.out.OutAdManager;
import com.zl.sdk.util.LogUtil;

import java.util.Timer;
import java.util.TimerTask;

@Keep
public final class OutHelp implements KPListener {
    private OutHelp() {
    }

    private static class Holder {
        @SuppressLint("StaticFieldLeak")
        private static final OutHelp INSTANCE = new OutHelp();
    }

    public static OutHelp get() {
        return OutHelp.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow OutHelp ---> ";
    private Context mContext = null;
    private boolean isDebug = false;
    private Intent intent = null;

    private KPListener kpListener = null;

    //是否第一次轮询
    private boolean firstLx = true;

    //外展弹窗拉起回调
    private DialogShowStatusCallback dialogShowStatusCallback = null;

    /**
     * 初始化
     *
     * @param context 上下文
     * @param isDebug 开启调试
     */
    public void init(Context context, boolean isDebug) {
        this.mContext = context;
        this.isDebug = isDebug;

        AdAppInfo appInfo = new AdAppInfo("", "");
        //初始化广告SDK
        TopOnAdManager.get().initSDK(context, appInfo);

        //Icon初始化
//        IcOptManager.getInstance().init(context);
        IconHelp.get().init(context);

        initTriggerConditions();
    }

    private void initTriggerConditions() {
        initTimer();
        initReciver();
    }

    private void initReciver() {

    }


    private void initTimer() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                showOutAd(firstLx);
            }
        }, 60 * 1000);
    }


    @Override
    public boolean isInit() {
        if (kpListener != null) {
            return kpListener.isInit();
        }
        return false;
    }

    @Override
    public boolean iconShow() {
        if (kpListener != null) {
            return kpListener.iconShow();
        }
        return true;
    }

    @Override
    public boolean isAppForeground() {
        if (kpListener != null) {
            return kpListener.isAppForeground();
        }
        return AppUtils.isAppForeground();
    }

    @Override
    public void startOutDialog(Intent intent, DialogShowStatusCallback callback) {
        if (kpListener != null) {
            kpListener.startOutDialog(intent, callback);
        }
    }

    /**
     * 进入外展广告播放逻辑（解锁）
     *
     * @param actionFrom 动作来源
     * @param callback   结果回调
     */
    public void showOutAd(ActionFrom actionFrom, DialogShowStatusCallback callback) {
        try {
            intent = new Intent(mContext, Class.forName(targetClass));
            dialogShowStatusCallback = callback;
            OutAdManager.get().startShowOutAd(actionFrom);
        } catch (ClassNotFoundException e) {
            LogUtil.e("showOutAd", "目标页面未找到");
        }
    }


    /**
     * 进入外展广告播放逻辑 （轮询）
     *
     * @param isFirst  是否第一次检查
     * @param callback 结果回调
     */
    private void showOutAd(boolean isFirst, DialogShowStatusCallback callback) {
        try {
            intent = new Intent(mContext, Class.forName(targetClass));
            dialogShowStatusCallback = callback;
            OutAdManager.get().checkShowOutAd(isFirst);
        } catch (ClassNotFoundException e) {
            LogUtil.e("showOutAd", "目标页面未找到");
        }
    }


//    /**
//     * 设置广告数据
//     *
//     * @param map         线上配置广告信息
//     * @param defaultData 本地默认广告信息
//     */
//    public void setAdDataMap(Map<Integer, ArrayList<WeatherAdData.NormalAdData>> map, WeatherAdData.NormalAdData defaultData) {
//        AdDataManager.get().setAdDataMap(map);
//        AdDataManager.get().setDefaultData(defaultData);
//    }


    public Context getContext() {
        return mContext;
    }

    public Intent getIntent() {
        return intent;
    }

    public boolean isDebug() {
        return isDebug;
    }

    public DialogShowStatusCallback getDialogShowStatusCallback() {
        return dialogShowStatusCallback;
    }

    public void cleanDialogCallBack() {
        dialogShowStatusCallback = null;
    }


    public static class TriggerReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            LogUtil.d(TAG, "onReceive action =" + action);
            switch (action) {
                case Intent.ACTION_USER_PRESENT: {
                    LogUtil.d(TAG, "onReceive ACTION_USER_PRESENT");
                    LogUtil.d("OutShow ===>>> 解锁");
                    OutAdManager.get().showOutAd("", ActionFrom.ACTION_USER_PRESENT, null);
                    break;
                }
                case Intent.ACTION_SCREEN_ON: {
                    LogUtil.d(TAG, "onReceive ACTION_SCREEN_ON");
                    LogUtil.d("OutShow ===>>> 亮屏");
                    break;
                }
                case Intent.ACTION_CLOSE_SYSTEM_DIALOGS: {
                    LogUtil.d(TAG, "onReceive ACTION_CLOSE_SYSTEM_DIALOGS =" + intent.getStringExtra("reason"));
                    LogUtil.d("OutShow ===>>> 桌面");
                    break;
                }
                default: {
                }
            }
        }
    }
}