package com.zl.sdk.out;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.text.format.DateUtils;

import com.zl.sdk.Config;
import com.zl.sdk.OutHelp;
import com.zl.sdk.ad.AdDataManager;
import com.zl.sdk.ad.TopOnAdLoadManager;
import com.zl.sdk.bean.OutAdData;
import com.zl.sdk.bean.RemindersInfo;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.AdScenes;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.out.ui.DxActivity;
import com.zl.sdk.util.AppOutUtils;
import com.zl.sdk.util.LogUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import cn.kuwo.show.mod.ACTD;


public class OutAdManager extends BaseOutShowManager {
    private OutAdManager() {
    }

    private static final OutAdManager INSTANCE = new OutAdManager();

    public static OutAdManager get() {
        return INSTANCE;
    }

    private static final String TAG = "OutShow OutAdManager --> ";

    //展示广告失败次数
    private int showAdFailTimes = 0;
    //是否重试了
    private volatile boolean hadStartAdDialogFail = false;
    //上次拉起外展弹窗时间
    private long lastStartAdDialogTime = 0L;
    //限制不能重复拉起外展弹窗的时间
//    private final long startAdDialogIntervalTime = 5 * 1000L;

    public void cleanLoadAdFailTime() {
        showAdFailTimes = 0;
    }

    @Override
    OutAdData.NormalAdData getAdData() {
        return AdDataManager.get().getShowAdData();
    }


    @Override
    RemindersInfo getReminderInfo() {
        RemindersInfo remindersInfo = new RemindersInfo();
        remindersInfo.reminderType = Config.REMINDER_TYPE_WEATHER_PURE_AD;
        remindersInfo.adScene = Config.AD_SCENE_TYPE_HOME;
        remindersInfo.isAdType = true;
        return remindersInfo;
    }


    @Override
    boolean checkCanShowForRemindInfo(RemindersInfo remindersInfo) {
        return false;
    }

    @Override
    boolean checkCanShowForActionState(OutAdData.NormalAdData adData, int actionState) {
        if (adData == null) {
            LogUtil.d(TAG + "能否播放（广告信息） ：广告信息为空 false");
            return false;
        }

        LogUtil.d(TAG + "广告信息=" + adData);

        boolean canShowByScene = CheckHelper.checkAdCanShowByScene(actionState, EventUtils.SCENES_SHOW);
        boolean adDataCanShow = CheckHelper.checkCanShowAdByTimesFromAdData(adData, actionState, EventUtils.SCENES_SHOW);
        boolean adReady = CheckHelper.checkAdReady(adData, EventUtils.SCENES_SHOW);

        LogUtil.d(TAG + "能否播放（场景检查） ：" + canShowByScene);
        LogUtil.d(TAG + "能否播放（次数检查）：" + adDataCanShow);
        LogUtil.d(TAG + "能否播放（缓存检查） ：" + adReady);

        return canShowByScene && adDataCanShow && adReady;
    }


    /**
     * 此设备是否是第一次播放外展
     *
     * @return
     */
    private boolean isAppFirstStartInTheDevices() {
        boolean isAppFirstStartInTheDevices = AppOutSP.isAppFirstStart();
        if (isAppFirstStartInTheDevices) {
            AppOutSP.setIsAppFirstStart(false);
        }
        return isAppFirstStartInTheDevices;
    }


    /**
     * 检查是否需要展示外展广告（轮询）
     */
    public void checkShowOutAd() {
        EventUtils.statTimeTriggle();

        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> START");
        LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> START");
        LogUtil.d(TAG);

        OutAdData.NormalAdData adData = getAdData();

        if (adData == null) {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> END 广告信息为空 不播放");
            LogUtil.d(TAG);
            return;
        }

        long lastShowTime = OutHelp.get().getLastShowTime();
        long curTime = System.currentTimeMillis();
        long showIntervalTime = Math.abs(curTime - lastShowTime);
        LogUtil.d(TAG + "检查是否需要展示广告 上次展示时间=" + lastShowTime);

        long spaceTime;

        if (OutHelp.get().iconIsHide()) {
            spaceTime = adData.intervalHide * DateUtils.SECOND_IN_MILLIS;
            LogUtil.d(TAG + "检查是否需要展示广告 间隔时间(icon隐藏)=" + spaceTime);
        } else {
            spaceTime = adData.interval * DateUtils.SECOND_IN_MILLIS;
            LogUtil.d(TAG + "检查是否需要展示广告 间隔时间(icon未隐藏)=" + spaceTime);
        }
        LogUtil.d(TAG + "检查是否需要展示广告 播放间隔时间=" + showIntervalTime);

        if (showIntervalTime < spaceTime) {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> END 未达到间隔时间 不播放");
            LogUtil.d(TAG);

            Statistics.getInstance().dotEvent("lx_fail");
        } else {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> END 达到间隔时间 播放");
            LogUtil.d(TAG);

            startShowOutAd(ActionFrom.ACTION_TIMER);
            Statistics.getInstance().dotEvent("lx_success");
        }
    }


    /**
     * 广告播放失败时，检查重试次数，间隔重试时间再次播放
     */
    public void showAdFail() {
        showAdFailTimes++;
        LogUtil.d(TAG + ">>>重试检查<<< =============>>> START");
        LogUtil.d(TAG + ">>>重试检查<<< 配置 重试间隔时间：" + IconHelp.get().getRetryShowAdTime() + "ms 重试次数：" + IconHelp.get().getRetryShowAdCount());
        if (showAdFailTimes <= IconHelp.get().getRetryShowAdCount()) {
            LogUtil.d(TAG + ">>>重试检查<<< =============>>> END 需要重试 计时" + IconHelp.get().getRetryShowAdTime() + "ms后再次重试 当前重试次数：" + showAdFailTimes);
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                checkNeedLoadAd(ActionFrom.ACTION_UNKNOWN);
                LogUtil.d(TAG + ">>>重试检查<<< 计时完成，去重新加载广告");
            }, IconHelp.get().getRetryShowAdTime());
        } else {
            LogUtil.d(TAG + ">>>重试检查<<< =============>>> END 重试超过次数 不再重试");

            returnFailCallBack("retry over time");

            cleanLoadAdFailTime();

            OutHelp.get().setLastShowTime();
//            AppOutSP.saveHomeLastShowTime(System.currentTimeMillis());
        }
    }

    /**
     * 开始进入广告逻辑
     *
     * @param actionFrom
     */
    public void startShowOutAd(ActionFrom actionFrom) {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>广告逻辑开始<<< ===> START action=" + actionFrom);
        LogUtil.d(TAG);

        doWork(actionFrom, true);
    }


    private long lastDoWork = 0L;

    /**
     * 外展逻辑开始
     *
     * @param actionFrom
     */
    public void doWork(ActionFrom actionFrom, boolean checkLastDoWorkTime) {
        if (checkLastDoWorkTime && System.currentTimeMillis() - lastDoWork < 500) {
            Statistics.getInstance().dotEvent(EventUtils.OUT_AD_START_FAIL_INVERT_TIME);
            LogUtil.d(TAG + ">>>播放广告<<<  =============>>> END 触发太频繁");
            return;
        }

        lastDoWork = System.currentTimeMillis();

        Map<String, Object> map = new HashMap<>();
        map.put("type", String.valueOf(actionFrom.getAction()));
        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), EventUtils.OUT_AD_START, "", map);

        OutAdData.NormalAdData adData = getAdData();

        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>播放广告<<< =============>>> start");
        LogUtil.d(TAG);

//        TODO
//        if (DeepNight.checkDeepNightRunning()) {
//           OutHelp.get().wakeOn();
//        }

        // 场景检查
        boolean canShowByScene = CheckHelper.checkAdCanShowByScene(actionFrom.getAction(), EventUtils.SCENES_SHOW);
        //次数检查和时间间隔检查
        boolean adTimesNoExceed = CheckHelper.checkCanShowAdByTimesFromAdData(adData, actionFrom.getAction(), EventUtils.SCENES_SHOW);
        //是否有缓存
        boolean adReady = CheckHelper.checkAdReady(adData, EventUtils.SCENES_SHOW);

        //能否展示广告
        boolean adCanShow = canShowByScene && adTimesNoExceed && adReady;

        if (adCanShow) {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>播放广告<<< ============>>> END 检查通过 开始启动SLK");
            LogUtil.d(TAG);

            hadStartAdDialogFail = false;

            if (!AppOutUtils.isScreenOn()) {
                OutHelp.get().wakeOn();
            }

            startAdDialog(OutHelp.get().getContext(), actionFrom, getReminderInfo(), adData);
            return;
        }

        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>播放广告<<<  =============>>> END 不能播放广告");
        LogUtil.d(TAG);

        OutHelp.get().setShowLock(false);

        //能否预加载广告
        boolean adCanLoad = canShowByScene && adTimesNoExceed && !adReady;
        if (adCanLoad) {
            LogUtil.d(TAG + ">>>播放广告<<<  =============>>> END 不能播放广告 场景检测通过，去加载广告");
            preloadByData(actionFrom, adData);
        } else {
            LogUtil.d(TAG + ">>>播放广告<<<  =============>>> END 不能播放广告 场景检测不通过，不能加载广告");
            returnFailCallBack("scene check fail");
        }
    }


    /**
     * 外展逻辑完成-成功
     */
    private void returnSuccessCallBack() {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>广告逻辑结束<<< ===> END 返回成功");
        LogUtil.d(TAG);
    }

    /**
     * 外展逻辑完成-失败
     */
    private void returnFailCallBack(String reason) {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>广告逻辑结束<<< ===> END 返回失败 reason=" + reason);
        LogUtil.d(TAG);
    }


    /**
     * 去拉起外展弹窗  播放or加载广告
     */
    private void startAdDialog(Context context, ActionFrom actionFrom, RemindersInfo remindersInfo, OutAdData.NormalAdData data) {
//        if (System.currentTimeMillis() - lastStartAdDialogTime <= startAdDialogIntervalTime) {
//            EventUtils.staDialogFail(DialogFailReason.INTERVAL_TIME_START_DIALOG, actionFrom.getAction(), EventUtils.SCENES_SHOW, EventUtils.DIALOG_TYPE_AD);
//            LogUtil.d(TAG + "拉起外展弹窗失败 : 5秒内不能重复拉起");
//            return;
//        }
//
//        lastStartAdDialogTime = System.currentTimeMillis();


        try {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(context, OutHelp.get().getActivityName()));
            try {
                intent.putExtra(ACTD.ATD, DxActivity.class.getName());
                intent.putExtra("SDK_NAME", OutHelp.get().getSdkName());
            } catch (Exception e) {
                intent.putExtra(ACTD.ATD, DxActivity.class.getName());
            }

            if (AppOutUtils.isScreenLock()) {
                AppOutUtils.unlockSystem();
            }

            DxManager.get().setOutRemindersInfo(remindersInfo);
            DxManager.get().setOutAdData(data);

            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START, "", true, actionFrom.getAction());

//            NotificationConfig notificationConfig = new NotificationConfig(null);
            //这个参数传0 就是不悬挂在桌面，1000 就是悬挂一秒，-1 就是持续悬挂
//            notificationConfig.duration = 0;

            LogUtil.d(TAG + "拉起广告弹窗 :" + OutHelp.get().getSdkName());

            OutHelp.get().startOutDialog(intent, new DialogShowStatusCallback() {
                @Override
                public void success() {
                    outDialogShowSuccess(actionFrom);
                }

                @Override
                public void fail(String reason) {
                    outDialogShowFail(context, actionFrom, remindersInfo, data, reason);
                }
            });
        } catch (Exception e) {
            LogUtil.d(TAG + "广告弹窗 拉起失败 catch 不再重试");
            returnFailCallBack("slk show fail");
            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_NO, e.toString(), true, actionFrom.getAction());
        }
    }

    private void outDialogShowFail(Context context, ActionFrom actionFrom, RemindersInfo remindersInfo, OutAdData.NormalAdData data, String reason) {
        LogUtil.d(TAG, "广告弹窗 拉起失败 失败原因：" + reason);
        try {
            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_NO, reason, true, actionFrom.getAction());

            OutHelp.get().clearNotification();
//            if (!hadStartAdDialogFail) {
//            hadStartAdDialogFail = true;
//            LogUtil.d(TAG, "广告弹窗 拉起失败 " + startAdDialogIntervalTime + "后重试一次");
//            new Handler().postDelayed(() -> startAdDialog(context, actionFrom, remindersInfo, data), startAdDialogIntervalTime);
//            } else {
//                LogUtil.d(TAG + "广告弹窗 拉起失败 已经重试一次，不再重试");
//                LogUtil.d(TAG + "广告弹窗 拉起失败 ，不再重试");
//                returnFailCallBack(reason);
//            }
        } catch (Throwable ignored) {
        }
    }

    private void outDialogShowSuccess(ActionFrom actionFrom) {
        LogUtil.d(TAG + "广告弹窗（播放） 拉起成功");
        try {
            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_OK, "", true, actionFrom.getAction());
            returnSuccessCallBack();
        } catch (Throwable ignored) {
        }
    }


    /**
     * 不能进入广告播放逻辑
     * 检查是否需要加载广告
     * <p>
     * 场景检查以通过
     * 检查广告数据和缓存
     * 再去加载广告
     */
    public void checkNeedLoadAd(ActionFrom actionFrom) {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>加载广告<<< =============>>> start");
        LogUtil.d(TAG);

        ArrayList<OutAdData.NormalAdData> list = AdDataManager.get().getOutAdData(OutAdData.POSITION_HOME, OutAdData.CP_AD_TOPON);

        int size = list.size();

        if (size == 0) {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 外展广告数据为空");
            LogUtil.d(TAG);

            OutAdData.NormalAdData localData = getAdData();

            if (localData != null
                    && CheckHelper.checkAdCanShowByScene(actionFrom.getAction(), EventUtils.SCENES_CHECK)
                    && CheckHelper.checkCanShowAdByTimesFromAdData(localData, -1, EventUtils.SCENES_CHECK)
                    && !CheckHelper.checkAdReady(localData, EventUtils.SCENES_CHECK)) {
                LogUtil.d(TAG);
                LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 加载广告（使用本地数据）");
                LogUtil.d(TAG);
                preloadByData(actionFrom, localData);
            } else {
                LogUtil.d(TAG);
                LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 没有能加载的广告");
                LogUtil.d(TAG);
                returnFailCallBack("no ad data");
            }
            return;
        }


        OutAdData.NormalAdData preLoadData;

        for (int i = 0; i < size; i++) {
            preLoadData = list.get(i);

            LogUtil.d(TAG + ">>>加载广告<<< index:" + i + " 检查广告能否加载：" + preLoadData);

            if (CheckHelper.checkCanShowAdByTimesFromAdData(preLoadData, -1, EventUtils.SCENES_CHECK)
                    && !CheckHelper.checkAdReady(preLoadData, EventUtils.SCENES_CHECK)) {

                LogUtil.d(TAG);
                LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 加载广告");
                LogUtil.d(TAG);

                preloadByData(actionFrom, preLoadData);
                return;
            }
        }

        returnFailCallBack("no ad data");

        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 没有能加载的广告");
        LogUtil.d(TAG);
    }


    /**
     * 前置条件检查都已通过，直接去加载广告
     */
    private void preloadByData(ActionFrom actionFrom, OutAdData.NormalAdData normalAdData) {
        if (normalAdData == null) {
            returnFailCallBack("ad data is null");
            return;
        }


        LogUtil.d(TAG + "加载广告(插屏) adData ：" + normalAdData);
        hadStartAdDialogFail = false;
        LogUtil.d(TAG + ">>>加载广告<<<  =============>>> END 去加载广告");
        try {
            TopOnAdLoadManager.getInstance().loadInterstitialAd(normalAdData, AdScenes.AD_SCENES_PURE);
        }catch (Exception e){
            Map<String, Object> map = new HashMap<>();
            map.put("reason", e.getMessage());
            map.put("scenes", "load ad");
            Statistics.getInstance().dotEvent(OutHelp.get().getContext(), "class error", "", map);
        }
    }


    public void showAdSuccess(OutAdData.NormalAdData adData) {
        LogUtil.d(TAG, "showAdSuccess adData =" + adData);
        if (adData == null) {
            return;
        }
        int outInterstitialAdDayShowCount = AppOutSP.getOutInterstitialAdDayShowCount();
        AppOutSP.saveOutInterstitialAdDayShowCount(++outInterstitialAdDayShowCount);
        LogUtil.d(TAG, "showAdSuccess interstitial outInterstitialAdDayShowCount =" + outInterstitialAdDayShowCount);
    }

    public void adClosed() {
    }
}