package com.zl.sdk.ad.interstitial;

import android.app.Activity;
import android.text.TextUtils;

import com.zl.sdk.ad.AdBean;

import java.util.HashMap;

public class TopOnInterstitialAdLoad {

    private HashMap<String, TopOnInterstitialAdManager> hashMap;


    public TopOnInterstitialAdLoad() {
        hashMap = new HashMap<>();
    }

    public void loadInterstitialAd(AdBean adBean, TopOnAdInterstitialCallBack adInterstitialCallBack) {
        String key = adBean.getAdUnitId();
        TopOnInterstitialAdManager interstitialAdManager = hashMap.get(key);
        if (null == interstitialAdManager) {
            interstitialAdManager = new TopOnInterstitialAdManager();
            hashMap.put(key, interstitialAdManager);
        }
        interstitialAdManager.setAdBean(adBean).loadInterstitialAd(adInterstitialCallBack);
    }

    public boolean isReady(String adUnitId) {
        if (TextUtils.isEmpty(adUnitId)) {
            return false;
        }
        TopOnInterstitialAdManager maxInterstitialAdManager = hashMap.get(adUnitId);
        return null != maxInterstitialAdManager && maxInterstitialAdManager.isReady();
    }

    public void showInterstitialAd(Activity activity,AdBean adBean) {
        if (adBean == null) {
            return;
        }
        String keyId = adBean.getAdUnitId();
        TopOnInterstitialAdManager maxInterstitialAdManager = hashMap.get(keyId);
        if (null != maxInterstitialAdManager) {
            maxInterstitialAdManager.setAdBean(adBean);
            maxInterstitialAdManager.showInterstitialAd(activity);
        }
    }

    public void destroy(String adUnitId) {
        TopOnInterstitialAdManager maxInterstitialAdManager = hashMap.get(adUnitId);
        if (null != maxInterstitialAdManager) {
            maxInterstitialAdManager.destroy();
        }
    }

}
