/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import com.or.ange.dot.CountryUtil;
import com.or.ange.dot.Event;
import com.or.ange.dot.EventGetter;
import com.or.ange.dot.Http;
import com.or.ange.dot.SystemUtils;
import com.or.ange.dot.UsageStats;
import com.or.ange.dot.utils.DeviceIDUtils;
import com.or.ange.dot.utils.LLog;
import com.or.ange.dot.utils.MD5;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ReportRunnable
implements Runnable {
    private static final String TAG = "ReportRunnable";
    private JSONObject common;
    private final String imei;
    private final String androidId;
    private String appId;
    private String country;
    private String language;
    private String countryCode;
    private String simOperatorMcc;
    private volatile boolean isReporting = false;

    ReportRunnable() {
        try {
            this.appId = UsageStats.getAppId();
            if (TextUtils.isEmpty((CharSequence)this.appId)) {
                this.appId = MD5.getString(UsageStats.getContext().getPackageName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.imei = DeviceIDUtils.getImei(UsageStats.getContext());
        this.androidId = SystemUtils.getAndroidId(UsageStats.getContext());
        try {
            this.country = Locale.getDefault().getCountry();
            this.language = Locale.getDefault().getLanguage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.countryCode = CountryUtil.getCountryCode(UsageStats.getContext());
            this.simOperatorMcc = CountryUtil.getSimOperatorMcc(UsageStats.getContext());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Event> events = new ArrayList<Event>(EventGetter.get().getEvents());
        if (events.isEmpty()) {
            LLog.d(TAG, "events is empty, not report.");
            return;
        }
        if (events.size() > 30) {
            events = events.subList(0, 30);
        }
        boolean success = false;
        this.isReporting = true;
        BufferedReader br = null;
        try {
            JSONObject object = this.getTrackerJSONObject(events);
            HashMap<String, String> heads = new HashMap<String, String>();
            heads.put("Content-Type", "application/json");
            HttpURLConnection conn = Http.post(UsageStats.settings().getReportUrl(), heads, null, object.toString());
            if (conn != null) {
                boolean bl = success = conn.getResponseCode() == 200;
                if (success) {
                    StringBuilder rest = new StringBuilder();
                    br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                    String line = null;
                    while (null != (line = br.readLine())) {
                        rest.append(line);
                    }
                    byte[] data = Http.encrypt(rest.toString().getBytes(StandardCharsets.UTF_8));
                    JSONObject jsonObject = new JSONObject(new String(Base64.decode((byte[])data, (int)0)));
                    success = jsonObject.optInt("a") == 0;
                }
            }
        }
        catch (Exception e2) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (success) {
                LLog.i(TAG, "track before success:" + events.size() + ",origin :" + EventGetter.get().getEvents().size());
                for (Event event : events) {
                    EventGetter.get().trackSuccess(event);
                }
                LLog.i(TAG, "track after success size :" + EventGetter.get().getEvents().size());
            } else {
                LLog.w(TAG, "track fail.");
            }
            this.isReporting = false;
        }
    }

    private JSONObject getTrackerJSONObject(List<Event> events) {
        JSONObject object = new JSONObject();
        try {
            object.put("cp", (Object)this.getCommonJSONObject());
            JSONArray array = new JSONArray();
            for (Event event : events) {
                array.put((Object)this.getEventJSONObject(event));
            }
            object.put("e", (Object)array);
            object.put("n", (Object)"1");
        }
        catch (JSONException e) {
            LLog.w(TAG, e.toString());
        }
        return object;
    }

    @SuppressLint(value={"MissingPermission"})
    private JSONObject getCommonJSONObject() throws JSONException {
        Context context = UsageStats.getContext();
        if (this.common == null) {
            String pkgName = context.getPackageName();
            this.common = new JSONObject();
            this.common.put("ai", (Object)this.appId);
            this.common.put("i", (Object)this.imei);
            this.common.put("a_id", (Object)this.androidId);
            this.common.put("pk", (Object)pkgName);
            this.common.put("vc", (Object)UsageStats.getVersionCode());
            this.common.put("vn", (Object)UsageStats.getVersionName());
            this.common.put("ol", Build.VERSION.SDK_INT);
            this.common.put("ov", (Object)Build.VERSION.RELEASE);
            this.common.put("b", (Object)Build.BRAND);
            this.common.put("m", (Object)Build.MODEL);
            this.common.put("d", (Object)Build.DEVICE);
            this.common.put("bo", (Object)Build.BOARD);
            this.common.put("ft", (Object)Build.FINGERPRINT);
            this.common.put("hw", (Object)Build.HARDWARE);
            this.common.put("dy", (Object)Build.DISPLAY);
            this.common.put("id", (Object)Build.ID);
            this.common.put("pt", (Object)Build.PRODUCT);
            this.common.put("us", (Object)Build.USER);
            this.common.put("mf", (Object)Build.MANUFACTURER);
            this.common.put("cn", (Object)this.country);
            this.common.put("lag", (Object)this.language);
            this.common.put("coc", (Object)this.countryCode);
            this.common.put("som", (Object)this.simOperatorMcc);
            if (Build.VERSION.SDK_INT >= 26) {
                String serial = "";
                try {
                    serial = Build.getSerial();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.common.put("sn", (Object)serial);
            }
        }
        return this.common;
    }

    private JSONObject getEventJSONObject(Event event) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("ei", (Object)event.getEventId());
        if (!UsageStats.getContext().getPackageName().equals(event.getLabel())) {
            object.put("label", (Object)event.getLabel());
        }
        object.put("et", event.getTimestamp());
        if (!UsageStats.getVersionName().equals(event.getVersionName())) {
            object.put("vc", (Object)event.getVersionCode());
            object.put("vn", (Object)event.getVersionName());
        }
        if (!TextUtils.isEmpty((CharSequence)event.getParams())) {
            object.put("pm", (Object)new JSONObject(event.getParams()));
        }
        return object;
    }

    public boolean isReporting() {
        return this.isReporting;
    }
}

