/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.database;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Parcel;
import android.os.Parcelable;
import com.or.ange.database.LikePalException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

final class SerializeUtils {
    private static final Map<Class, Parcelable.Creator> sCreatorMap = new HashMap<Class, Parcelable.Creator>();

    SerializeUtils() {
    }

    static byte[] toBytes(Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        bitmap.recycle();
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] toBytes(Serializable obj) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            bos.toByteArray();
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    static byte[] toBytes(Parcelable obj) {
        if (obj != null) {
            return SerializeUtils.marshall(obj);
        }
        return null;
    }

    static Bitmap toBitmap(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends Serializable> T toSerializable(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bis);
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    static <T extends Parcelable> T toParcelable(byte[] bytes, Class parcelClass) {
        if (bytes == null) {
            return null;
        }
        return (T)((Parcelable)SerializeUtils.unmarshall(bytes, SerializeUtils.readParcelableCreator(parcelClass)));
    }

    private static byte[] marshall(Parcelable parcelable) {
        Parcel parcel = Parcel.obtain();
        parcelable.writeToParcel(parcel, 0);
        byte[] bytes = parcel.marshall();
        parcel.recycle();
        return bytes;
    }

    private static Parcel unmarshall(byte[] bytes) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(bytes, 0, bytes.length);
        parcel.setDataPosition(0);
        return parcel;
    }

    private static <T> T unmarshall(byte[] bytes, Parcelable.Creator<T> creator) {
        Parcel parcel = SerializeUtils.unmarshall(bytes);
        Object result = creator.createFromParcel(parcel);
        parcel.recycle();
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Parcelable.Creator<?> readParcelableCreator(Class parcelClass) {
        Parcelable.Creator creator;
        Map<Class, Parcelable.Creator> map = sCreatorMap;
        synchronized (map) {
            creator = sCreatorMap.get(parcelClass);
            if (creator == null) {
                try {
                    if (!Parcelable.class.isAssignableFrom(parcelClass)) {
                        throw new LikePalException("Parcelable protocol requires that the class implements Parcelable");
                    }
                    Field f = parcelClass.getField("CREATOR");
                    if ((f.getModifiers() & 8) == 0) {
                        throw new LikePalException("Parcelable protocol requires the CREATOR object to be static on class " + parcelClass.getSimpleName());
                    }
                    Class<?> creatorType = f.getType();
                    if (!Parcelable.Creator.class.isAssignableFrom(creatorType)) {
                        throw new LikePalException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + parcelClass.getSimpleName());
                    }
                    creator = (Parcelable.Creator)f.get(null);
                }
                catch (Exception e) {
                    throw new LikePalException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + parcelClass.getSimpleName());
                }
                if (creator == null) {
                    throw new LikePalException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + parcelClass.getSimpleName());
                }
                sCreatorMap.put(parcelClass, creator);
            }
        }
        return creator;
    }
}

