package com.zl.sdk.ad;

import android.app.Activity;
import android.util.Log;

import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.AdError;
import com.anythink.interstitial.api.ATInterstitial;
import com.anythink.interstitial.api.ATInterstitialListener;
import com.zl.sdk.OutHelp;
import com.zl.sdk.event.AdsParamsInfo;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.ReportBean;
import com.zl.sdk.out.AppOutSP;

import java.util.Date;

public class AdManagerV2 implements ATInterstitialListener {
    private ATInterstitial atInterstitial = null;

    private int reloadCount = 3;

    private String adId = "";

    private long requestTime = 0L;

    private static final AdManagerV2 mgr = new AdManagerV2();

    private AdManagerV2() {

    }

    public static AdManagerV2 get() {
        return mgr;
    }

    @Override
    public void onInterstitialAdLoaded() {
        Log.d("OutShow", "Topon: ad loaded");
        reloadCount = 3;

        if (atInterstitial.checkValidAdCaches() == null || atInterstitial.checkValidAdCaches().isEmpty()) {
            EventUtils.statAdLoaded(getReportBean(null, null), requestTime);
        } else {
            EventUtils.statAdLoaded(getReportBean(atInterstitial.checkValidAdCaches().get(0), null), requestTime);
        }
        //记录广告返回的时间，供上报缓存时间和价格
        requestTime = System.currentTimeMillis();
    }

    @Override
    public void onInterstitialAdLoadFail(AdError adError) {
        Log.d("OutShow", "Topon: ad load fail");
        String builder = "error info : code=" + adError.getCode() +
                " msg=" + adError.getDesc() +
                " all=" + adError.getFullErrorInfo();
        EventUtils.statAdLoadFail(getReportBean(null, builder), requestTime);

        reloadCount--;
        if (reloadCount > 0) {
            atInterstitial = new ATInterstitial(OutHelp.get().getContext(), adId);
            atInterstitial.setAdListener(this);
            atInterstitial.load();
            requestTime = System.currentTimeMillis();
            EventUtils.statAdReport(getReportRequestBean(adId));
        } else {
            reloadCount = 3;
        }
    }

    @Override
    public void onInterstitialAdClicked(ATAdInfo atAdInfo) {
        Log.d("OutShow", "Topon: ad click");
        EventUtils.statAdClick(getReportBean(atAdInfo, null));
    }

    @Override
    public void onInterstitialAdShow(ATAdInfo atAdInfo) {
        Log.d("OutShow", "Topon: ad show");

        int outInterstitialAdDayShowCount = AppOutSP.getOutInterstitialAdDayShowCount() + 1;
        AppOutSP.saveOutInterstitialAdDayShowCount(outInterstitialAdDayShowCount);

        Log.d("OutShow", "Topon: ad show times=" + outInterstitialAdDayShowCount);

        EventUtils.statAdExpose(getReportBean(atAdInfo, null));

        atInterstitial = new ATInterstitial(OutHelp.get().getContext(), adId);
        atInterstitial.setAdListener(this);
        atInterstitial.load();
        requestTime = System.currentTimeMillis();
        EventUtils.statAdReport(getReportRequestBean(adId));
    }

    @Override
    public void onInterstitialAdClose(ATAdInfo atAdInfo) {
        Log.d("OutShow", "Topon: ad close");
        EventUtils.statAdClose(getReportBean(atAdInfo, null));
    }

    @Override
    public void onInterstitialAdVideoStart(ATAdInfo atAdInfo) {
        Log.d("OutShow", "Topon: ad video start");
    }

    @Override
    public void onInterstitialAdVideoEnd(ATAdInfo atAdInfo) {
        Log.d("OutShow", "Topon: ad video end");
    }

    @Override
    public void onInterstitialAdVideoError(AdError adError) {
        Log.d("OutShow", "Topon: ad video error");
    }

    public void loadAd(String id) {
        Log.d("OutShow", "Topon: loadAd : " + id);
        adId = id;
        if (atInterstitial != null) {
            ATAdStatusInfo atAdStatusInfo = atInterstitial.checkAdStatus();
            if (!atAdStatusInfo.isReady() && !atAdStatusInfo.isLoading()) {
                atInterstitial.load();
                requestTime = System.currentTimeMillis();
                EventUtils.statAdReport(getReportRequestBean(adId));
            }
        } else {
            atInterstitial = new ATInterstitial(OutHelp.get().getContext(), adId);
            atInterstitial.setAdListener(this);
            atInterstitial.load();
            requestTime = System.currentTimeMillis();
            EventUtils.statAdReport(getReportRequestBean(adId));
        }
    }


    public boolean isAdReady() {
        if (atInterstitial != null) {
            ATAdStatusInfo atAdStatusInfo = atInterstitial.checkAdStatus();
            return atAdStatusInfo.isReady();
        } else {
            return false;
        }
    }

    public void showAd(Activity activity) {
        Log.d("OutShow", "Topon: showAd");
        ATInterstitial.entryAdScenario("111", "");
        atInterstitial.show(activity);
    }


    private ReportBean getReportBean(ATAdInfo adInfo, String errorMsg) {
        ReportBean bean = new ReportBean();
        bean.adtype = AdsParamsInfo.INTERSTITIAL;
        bean.adUnitId = adId;
        if (null != adInfo) {
            bean.platform = adInfo.getNetworkPlacementId();
            bean.source = adInfo.getAdNetworkType();
        }
        bean.ad_msg_error = errorMsg;
        bean.time = (new Date()).getTime();
        return bean;
    }

    private ReportBean getReportRequestBean(String adId) {
        ReportBean bean = new ReportBean();
        bean.eventid = AdsParamsInfo.F_REQUEST;
        bean.adtype = AdsParamsInfo.INTERSTITIAL;
        bean.adUnitId = adId;
        return bean;
    }
}
