package com.zl.sdk.ad.topOn;

import android.content.Context;

import com.anythink.core.api.ATSDK;
import com.zl.sdk.bean.AdAppInfo;
import com.zl.sdk.util.LogUtil;

import cn.kw.lib.common.PROP;

public class TopOnAdManager {
    private static String TAG = "OutShow TopOn Ad ---> ";

    private TopOnAdManager() {
    }

    private static class Holder {
        private static final TopOnAdManager INSTANCE = new TopOnAdManager();
    }

    public static TopOnAdManager get() {
        return Holder.INSTANCE;
    }

    public void initSDK(Context context, AdAppInfo appInfo) {
        if (appInfo == null) {
            LogUtil.e(TAG, "ad app info is null");
            return;
        }

        LogUtil.d(TAG + "初始化：topon应用信息：" + appInfo);

        //SDK日志功能，集成测试阶段建议开启，上线前必须关闭
        ATSDK.setNetworkLogDebug(PROP.isTest());

//        //检查广告平台的集成状态，提交审核时需注释此API
//        ATSDK.integrationChecking(context);
//
//        ATSDK.setDebuggerConfig(
//                context,
//                "7d4a26a8-9f4d-4f37-b4bf-40877b60a8e1",
//                new ATDebuggerConfig.Builder(Vungle_NETWORK).build());


        ATSDK.init(context, appInfo.app_id, appInfo.app_key);
        //SDK版本
        LogUtil.i(TAG, "TopOn SDK version: " + ATSDK.getSDKVersionName());

        //(v5.7.77新增) 打印当前设备的设备信息(IMEI、OAID、GAID、AndroidID等)
//        ATSDK.testModeDeviceInfo(context, new DeviceInfoCallback() {
//            @Override
//            public void deviceInfo(String deviceInfo) {
//                Log.i(TAG, "deviceInfo: " + deviceInfo);
//            }
//        });
    }
}
