package com.zl.sdk.icon;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PkgUtils {
    public static boolean isComponentEnabled(Context context, String component) {

        ComponentName componentName = ComponentName.unflattenFromString(component);

        int componentEnabledSetting = context.getPackageManager().getComponentEnabledSetting(
                componentName);

        switch (componentEnabledSetting) {
            case PackageManager.COMPONENT_ENABLED_STATE_DISABLED:
                return false;
            case PackageManager.COMPONENT_ENABLED_STATE_ENABLED:
                return true;
            case PackageManager.COMPONENT_ENABLED_STATE_DEFAULT:
            default:
                // We need to get the application info to get the component's default state
                try {
                    PackageInfo packageInfo = context.getPackageManager().getPackageInfo(
                            componentName.getPackageName(), PackageManager.GET_ACTIVITIES
                                    | PackageManager.GET_RECEIVERS
                                    | PackageManager.GET_SERVICES
                                    | PackageManager.GET_PROVIDERS
                                    | PackageManager.GET_DISABLED_COMPONENTS);

                    List<ComponentInfo> components = new ArrayList<>();
                    if (packageInfo.activities != null) {
                        Collections.addAll(components,
                                packageInfo.activities);
                    }
                    if (packageInfo.services != null) {
                        Collections.addAll(components,
                                packageInfo.services);
                    }
                    if (packageInfo.providers != null) {
                        Collections.addAll(components,
                                packageInfo.providers);
                    }

                    for (ComponentInfo componentInfo : components) {
                        if (componentInfo.name.equals(componentName.getClassName())) {
                            return componentInfo.isEnabled();
                        }
                    }

                    // the component is not declared in the AndroidManifest
                    return false;
                } catch (Exception e) {
                    // the package isn't installed on the device
                    return false;
                }
        }
    }

    public static void disableComponent(Context context, String componentString) {
        try {
            if (context == null || TextUtils.isEmpty(componentString)) {
                return;
            }
            PackageManager pm = context.getPackageManager();
            ComponentName componentName = ComponentName.unflattenFromString(componentString);
            if (componentName == null) {
                return;
            }
            pm.setComponentEnabledSetting(componentName, PackageManager.COMPONENT_ENABLED_STATE_DISABLED, 0);
        } catch (Throwable th) {
            Log.w("PkgUtils", "disableComponent" + th.getMessage());
        }
    }

    public static void enableComponent(Context context, String componentString) {
        try {
            if (context == null || TextUtils.isEmpty(componentString)) {
                return;
            }
            PackageManager pm = context.getPackageManager();
            ComponentName componentName = ComponentName.unflattenFromString(componentString);
            if (componentName == null) {
                return;
            }
            pm.setComponentEnabledSetting(componentName, PackageManager.COMPONENT_ENABLED_STATE_ENABLED, 0);
        } catch (Throwable th) {
            Log.w("PkgUtils", "disableComponent" + th.getMessage());
        }
    }

    public static long getAppLastInstallTime(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.lastUpdateTime;
        } catch (Exception e) {
        }
        return 0;
    }

    public static boolean isActivityEnable(Context context, String actitiyName) {
        try {
            String launcherComponent = context.getPackageName() + "/" + actitiyName;
            boolean isEnable = PkgUtils.isComponentEnabled(context, launcherComponent);
            return isEnable;
        } catch (Exception e) {
        }
        return true;
    }

}
