package com.ads.cal.calculator.utils;

import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

import androidx.annotation.Nullable;

import com.ads.cal.calculator.activity.CompassActivity;

public class CustomCompassView extends View {
    private Paint paint;
    private float azimuth = 0;

    public CustomCompassView(Context context) {
        super(context);
        init();

    }

    public CustomCompassView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public CustomCompassView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    public CustomCompassView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextSize(24);
        paint.setColor(Color.BLACK);
    }


    public void setAzimuth(float azimuth) {
        this.azimuth = azimuth;
        invalidate(); // 通知View重新绘制
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        int width = getWidth();
        int height = getHeight();
        int centerX = width / 2;
        int centerY = height / 2;
        int radius = 200; // 指南针的半径

        // 绘制指南针外圆
        paint.setColor(Color.BLACK);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(centerX, centerY, radius, paint);

        // 绘制指南针文字
        paint.setColor(Color.BLACK);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawText("N", centerX - 10, centerY - radius + 30, paint);
        canvas.drawText("S", centerX - 10, centerY + radius - 10, paint);
        canvas.drawText("E", centerX + radius - 30, centerY + 10, paint);
        canvas.drawText("W", centerX - radius + 10, centerY + 10, paint);

        // 绘制刻度和角度
        paint.setColor(Color.BLACK);
        paint.setTextSize(20);
        paint.setStyle(Paint.Style.FILL);

        for (int i = 0; i < 360; i += 30) {
            double angle = Math.toRadians(-i);
            float startX = centerX + (float) (radius * Math.sin(angle));
            float startY = centerY - (float) (radius * Math.cos(angle));
            float endX = centerX + (float) ((radius - 20) * Math.sin(angle));
            float endY = centerY - (float) ((radius - 20) * Math.cos(angle));

            // 绘制刻度线
            canvas.drawLine(startX, startY, endX, endY, paint);

            // 绘制角度文本
            String angleText = String.valueOf(i) + "°";
            float textWidth = paint.measureText(angleText);
            canvas.drawText(angleText, centerX - textWidth / 2, centerY - radius + 50, paint);
        }

        // 绘制指南针指针
        paint.setColor(Color.RED);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawLine(centerX, centerY, centerX + (float) (100 * Math.sin(Math.toRadians(-azimuth))), centerY - (float) (100 * Math.cos(Math.toRadians(-azimuth))), paint);
    }
}
