package com.ads.cal.calculator.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.widget.ProgressBar;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ads.cal.calculator.MainActivity;
import com.ads.cal.calculator.MyApplication;
import com.ads.cal.calculator.R;
import com.ads.cal.calculator.ad.AppOpenAdManager;
import com.ads.cal.calculator.base.BaseActivity;
import com.ads.cal.calculator.utils.EventIdUtils;
import com.ads.cal.calculator.utils.FireBaseAnalyticsUtils;
import com.ads.cal.calculator.utils.LogUtils;

import java.lang.ref.WeakReference;

@SuppressLint("CustomSplashScreen")
public class SplashActivity extends BaseActivity {

    private ProgressBar progressBar;

    private MyHandler myHandler;

    private boolean isGoHome = false;

    private static class MyHandler extends Handler {
        private final WeakReference<Context> contextWeakReference;
        private int value = 0;

        public MyHandler(Context context) {
            super();
            contextWeakReference = new WeakReference<>(context);
        }

        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            Context context = contextWeakReference.get();
            if (null == context) {
                return;
            }
            if (context instanceof SplashActivity) {
                if (msg.what == 1) {
                    if (value <= 100) {
                        ((SplashActivity) context).setProgressValue(value++, false);
                        sendEmptyMessageDelayed(msg.what, 10);
                    }
                }
            }
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LogUtils.log("application", "splash onCreate Time ==  "+ (System.currentTimeMillis() - MyApplication.startTime) / 1000);
    }

    @Override
    protected String getPageExpEventId() {
        return EventIdUtils.LAUNCH_EXP;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.app_activity_splash;
    }

    @Override
    protected void initView() {
        progressBar = findViewById(R.id.progress_circular);
        myHandler = new MyHandler(this);
    }


    @Override
    protected void onResume() {
        super.onResume();
        LogUtils.log("application", "splash onResume Time ==  "+ (System.currentTimeMillis() - MyApplication.startTime) / 1000);
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    private void setProgressValue(int progress, boolean adLoadSuccess) {
        if (null != progressBar) {
            progressBar.setProgress(progress);
        }
        LogUtils.log("progress  " + progress);
        if (progress >= 100) {
            myHandler.removeCallbacksAndMessages(null);
            if (adLoadSuccess) {
                return;
            }
            LogUtils.log("goHome  ");
            goHome();
        }
    }

    private void goHome() {
        if (isGoHome) {
            return;
        }
        isGoHome = true;
//        MyApplication application = MyApplication.getApplication();
//        AppOpenAdManager appOpenAdManager = application.getAppOpenAdManager();
//        if (null != appOpenAdManager) {
//            appOpenAdManager.setOnLoadAdCompleteListener(null);
//            appOpenAdManager.setOnShowAdCompleteListener(null);
//        }
        MainActivity.invoke(SplashActivity.this);
        finish();
        overridePendingTransition(0, 0);
    }

    @Override
    protected void initData() {
//        MyApplication application = MyApplication.getApplication();
//        AppOpenAdManager appOpenAdManager = application.getAppOpenAdManager();
//        if (null == appOpenAdManager) {
//            return;
//        }
//        if (appOpenAdManager.isAdAvailable()) {
//            FireBaseAnalyticsUtils.init().send(EventIdUtils.AD_OPEN_HAS_CACHE);
//            LogUtils.log("showOpenAd");
//            showOpenAd(appOpenAdManager);
//            setProgressValue(100, true);
//        } else {
//            FireBaseAnalyticsUtils.init().send(EventIdUtils.AD_OPEN_NOT_CACHE);
//            LogUtils.log("loadOpenAd");
//            loadOpenAd(appOpenAdManager);
//            myHandler.sendEmptyMessage(1);
//        }
        myHandler.sendEmptyMessage(1);
    }

    private void showOpenAd(AppOpenAdManager appOpenAdManager) {
        appOpenAdManager.setOnShowAdCompleteListener(new AppOpenAdManager.OnShowAdCompleteListener() {
            @Override
            public void onShowAdComplete() {
                LogUtils.log("onShowAdComplete");
                goHome();
            }

            @Override
            public void onShowAdFailed(String errorMsg) {
                LogUtils.log(errorMsg);
                goHome();
            }
        });
        appOpenAdManager.showAdIfAvailable(this);
    }

    private void loadOpenAd(AppOpenAdManager appOpenAdManager) {
        appOpenAdManager.setOnLoadAdCompleteListener(new AppOpenAdManager.OnLoadAdCompleteListener() {
            @Override
            public void onLoadAdComplete() {
                LogUtils.log("onLoadAdComplete");
                setProgressValue(100, true);
                showOpenAd(appOpenAdManager);
            }

            @Override
            public void onLoadAdFailed(String errorMsg) {
                LogUtils.log(errorMsg);
                setProgressValue(100, false);
            }
        });
        appOpenAdManager.loadAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (null != myHandler) {
            myHandler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    public void onBackPressed() {

    }
}
