package com.ads.cal.calculator;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;

import com.ads.cal.calculator.activity.SplashActivity;
import com.ads.cal.calculator.ad.AppOpenAdManager;
import com.ads.cal.calculator.utils.EventIdUtils;
import com.ads.cal.calculator.utils.FireBaseAnalyticsUtils;
import com.ads.cal.calculator.utils.LogUtils;
import com.google.android.gms.ads.MobileAds;

public class MyApplication extends Application
        implements Application.ActivityLifecycleCallbacks, DefaultLifecycleObserver {

    @SuppressLint("StaticFieldLeak")
    private static MyApplication application;
    private Activity currentActivity;
//    private AppOpenAdManager appOpenAdManager;

    public static MyApplication getApplication() {
        return application;
    }

//    public AppOpenAdManager getAppOpenAdManager() {
//        return appOpenAdManager;
//    }

    private int foregroundPageNumbers = 0;

    public boolean isHotStartUp() {
        boolean isHotStat = foregroundPageNumbers == 1;
        LogUtils.log("isHotStat = " + isHotStat);
        return isHotStat;
    }

    public static long startTime = 0;

    @Override
    public void onCreate() {
        startTime = System.currentTimeMillis();
        LogUtils.log("application", "init start Time ==  "+ startTime);
        super.onCreate();
        application = this;
        this.registerActivityLifecycleCallbacks(this);
        ProcessLifecycleOwner.get().getLifecycle().addObserver(application);
//        initAd();
        FireBaseAnalyticsUtils.init();
        LogUtils.setConsoleLoggingEnabled(true);
        LogUtils.log("application", "init finish Time ==  "+ (System.currentTimeMillis() - startTime) / 1000);
    }

    /**
     * DefaultLifecycleObserver method that shows the app open ad when the app moves to foreground.
     */
    @Override
    public void onStart(@NonNull LifecycleOwner owner) {
        DefaultLifecycleObserver.super.onStart(owner);

        LogUtils.log("currentActivity  == " + currentActivity);
        // Show the ad (if available) when the app moves to foreground.
        if (currentActivity instanceof SplashActivity) {
            return;
        }
//        if (appOpenAdManager.isAdAvailable()) {
//            FireBaseAnalyticsUtils.init().send(EventIdUtils.AD_OPEN_HAS_CACHE);
//        } else {
//            FireBaseAnalyticsUtils.init().send(EventIdUtils.AD_OPEN_NOT_CACHE);
//        }
//        appOpenAdManager.showAdIfAvailable(currentActivity);
    }

    private void initAd() {
//        MobileAds.initialize(application, initializationStatus -> {
//        });
//        initAppOpenAdManager();
//        appOpenAdManager.loadAd();
    }

    private void initAppOpenAdManager() {
//        appOpenAdManager = new AppOpenAdManager();
    }

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        foregroundPageNumbers--;
//        if (!appOpenAdManager.isShowingAd()) {
//            currentActivity = activity;
//        }
    }

    @Override
    public void onActivityStarted(@NonNull Activity activity) {
        LogUtils.log("onActivityStarted   ---   " + activity.getLocalClassName());
        boolean isHotStartUp = isHotStartUp();
        foregroundPageNumbers++;
        if (isHotStartUp) {
            FireBaseAnalyticsUtils.init().send(EventIdUtils.HOT_START);
        }
    }

    @Override
    public void onActivityResumed(@NonNull Activity activity) {
        LogUtils.log("onActivityResumed   ---   " + activity.getLocalClassName());

    }

    @Override
    public void onActivityPaused(@NonNull Activity activity) {
        LogUtils.log("onActivityPaused   ---   " + activity.getLocalClassName());

    }

    @Override
    public void onActivityStopped(@NonNull Activity activity) {
        LogUtils.log("onActivityStopped   ---   " + activity.getLocalClassName());

    }

    @Override
    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        LogUtils.log("onActivitySaveInstanceState   ---   " + activity.getLocalClassName());

    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {
        LogUtils.log("onActivityDestroyed   ---   " + activity.getLocalClassName());

    }
}
