package com.ads.cal.calculator.utils;

import android.app.Application;
import android.os.Bundle;

import com.ads.cal.calculator.MyApplication;
import com.google.firebase.analytics.FirebaseAnalytics;

public class FireBaseAnalyticsUtils {

    private final FirebaseAnalytics mFirebaseAnalytics;
    private static volatile FireBaseAnalyticsUtils fireBaseAnalyticsUtils;

    private FireBaseAnalyticsUtils(Application application) {
        mFirebaseAnalytics = FirebaseAnalytics.getInstance(application);
    }

    public static FireBaseAnalyticsUtils init() {
        if (fireBaseAnalyticsUtils == null) {
            synchronized (FireBaseAnalyticsUtils.class) {
                if (fireBaseAnalyticsUtils == null) {
                    fireBaseAnalyticsUtils = new FireBaseAnalyticsUtils(MyApplication.getApplication());
                }
            }
        }
        return fireBaseAnalyticsUtils;
    }

    public void send(String eventId, Bundle bundle) {
        if (mFirebaseAnalytics == null) {
            LogUtils.log("mFirebaseAnalytics ==    null  " +eventId);
            return;
        }
        LogUtils.log("eventId     " +eventId);
        mFirebaseAnalytics.logEvent(eventId, bundle);
    }

    public void send(String eventId) {
        send(eventId, new Bundle());
    }




}
