package com.ads.cal.calculator.base;

import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.Window;

import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;

import com.ads.cal.calculator.R;
import com.ads.cal.calculator.activity.AboutActivity;
import com.ads.cal.calculator.activity.SettingActivity;
import com.ads.cal.calculator.activity.SplashActivity;
import com.ads.cal.calculator.utils.FireBaseAnalyticsUtils;


public abstract class BaseActivity extends FragmentActivity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = getWindow();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            window.setStatusBarColor(getColor(getStatusBarColor())); // 设置颜色
        } else {
            window.setStatusBarColor(getResources().getColor(getStatusBarColor())); // 设置颜色
        }
        setContentView(getLayoutId());
        initView();
        initData();
        String eventId = getPageExpEventId();
        if (null != eventId) {
            FireBaseAnalyticsUtils.init().send(eventId);
        }
    }

    protected abstract String getPageExpEventId();

    protected abstract int getLayoutId();

    protected abstract void initView();

    protected abstract void initData();

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    private int getStatusBarColor() {
        if (this instanceof SettingActivity
            || this instanceof AboutActivity) {
            return R.color.white;
        }
        if (this instanceof SplashActivity) {
            return R.color.app_00FFD8D8;
        }
        return R.color.app_f1f4f6;
    }
}
