package com.ads.cal.calculator.activity;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.webkit.WebView;

import com.ads.cal.calculator.R;
import com.ads.cal.calculator.base.BaseActivity;
import com.ads.cal.calculator.utils.EventIdUtils;

public class WebActivity extends BaseActivity {
    @Override
    protected String getPageExpEventId() {
        return EventIdUtils.PRIVACY_POLICY;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.app_activity_web;
    }

    private WebView webView;

    @Override
    protected void initView() {
        webView = findViewById(R.id.web);
        webView.loadUrl("file:///android_asset/privacypolicy.html");
        findViewById(R.id.back).setOnClickListener(view -> finish());
    }

    @Override
    protected void initData() {

    }

    @Override
    protected void onDestroy() {
        if (webView != null) {
            webView.loadUrl("about:blank"); // 加载一个空白页面，释放资源
            webView.clearHistory(); // 清除WebView的历史记录
            webView.destroy(); // 销毁WebView
        }
        super.onDestroy();
    }

    public static void invoke(Context context) {
        Intent intent = new Intent(context, WebActivity.class);
        context.startActivity(intent);
    }
}
