package com.ads.cal.calculator.activity;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;

import com.ads.cal.calculator.R;
import com.ads.cal.calculator.base.BaseActivity;
import com.ads.cal.calculator.utils.EventIdUtils;
import com.ads.cal.calculator.utils.FireBaseAnalyticsUtils;

public class SettingActivity extends BaseActivity {
    @Override
    protected String getPageExpEventId() {
        return EventIdUtils.SETTING_EXP;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.app_activity_setting;
    }

    @Override
    protected void initView() {
        findViewById(R.id.clear_data).setOnClickListener(view -> {
            ActivityManager am = (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
            am.clearApplicationUserData();
            FireBaseAnalyticsUtils.init().send(EventIdUtils.SETTING_CLEAR_DATA_CLK);
        });
        findViewById(R.id.about).setOnClickListener(view -> {
            AboutActivity.invoke(SettingActivity.this);
            FireBaseAnalyticsUtils.init().send(EventIdUtils.SETTING_ABOUT_US_CLK);
        });
        findViewById(R.id.privacy).setOnClickListener(view -> {
           WebActivity.invoke(SettingActivity.this);
            FireBaseAnalyticsUtils.init().send(EventIdUtils.SETTING_PRIVACY_CLK);
        });
        findViewById(R.id.back).setOnClickListener(view -> {
            finish();
        });
    }

    @Override
    protected void initData() {

    }

    public static void invoke(Context context) {
        Intent intent = new Intent(context, SettingActivity.class);
        context.startActivity(intent);
    }
}
