package com.ads.cal.calculator.activity;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.view.View;
import android.widget.TextView;

import com.ads.cal.calculator.R;
import com.ads.cal.calculator.base.BaseActivity;
import com.ads.cal.calculator.utils.EventIdUtils;

public class AboutActivity extends BaseActivity {
    @Override
    protected String getPageExpEventId() {
        return EventIdUtils.ABOUT_US_EXP;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.app_activity_about;
    }

    @Override
    protected void initView() {
        TextView textView = findViewById(R.id.text);
        try {
            PackageManager packageManager = getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(getPackageName(), 0);
            String appVersion = packageInfo.versionName;
            int appVersionCode = packageInfo.versionCode;
            textView.setText(String.format("VersionName: %s   VersionCode:  %d", appVersion, appVersionCode));
        } catch (Exception e) {

        }
        findViewById(R.id.back).setOnClickListener(view -> finish());
    }

    @Override
    protected void initData() {

    }

    public static void invoke(Context context) {
        Intent intent = new Intent(context, AboutActivity.class);
        context.startActivity(intent);
    }
}
