package com.gem.media;

import android.Manifest;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.PixelFormat;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.Gravity;
import android.view.WindowManager;
import android.widget.TextView;

import com.ads.cal.picturetranslate.PictureApplication;
import com.gem.media.splash.base.utils.ALog;
import com.or.ange.dot.UsageStats;

public class PViewManager {


    private static final class PViewManagerHolder {
        private static final PViewManager pViewManager = new PViewManager();
    }

    public static PViewManager getInstance() {
        return PViewManager.PViewManagerHolder.pViewManager;
    }

    private WindowManager windowManager;
    private TextView textView;
    private WindowManager.LayoutParams layoutParams;
    private static volatile boolean isWindowShowing = false;
    private static final Handler handler = new Handler(Looper.getMainLooper());

    private void createWindowView(Context context) {
        if (isWindowShowing) {
            handler.removeCallbacks(runnable);
            ALog.d("PViewManager", ""+isScreenLock(context)+"   isWindowShowing  "+isWindowShowing);
            return;
        }
        PackageManager pm = context.getPackageManager();
        int granted = pm.checkPermission(Manifest.permission.SYSTEM_ALERT_WINDOW, context.getPackageName());
        if (granted != PackageManager.PERMISSION_GRANTED) {
            StatsStaticHelper.onEvent("wm_not_per");
            ALog.d("PViewManager", "create window not permission");
            return;
        } else {
            StatsStaticHelper.onEvent("wm_per");
        }
        handler.removeCallbacks(runnable);
        if (!isMainThread()) {
            handler.post(runnable);
            ALog.d("PViewManager", "not isMainThread");
        } else {
            ALog.d("PViewManager", "isMainThread");
            create(context);
        }
        ALog.d("PViewManager", "create window start -- Thread = " + Thread.currentThread().getName()+"   mian  = " + Looper.getMainLooper().getThread().getName());

    }

    private final Runnable runnable = () -> create(PictureApplication.getApplication());

    private void create(Context context) {
        if (context == null) {
            return;
        }
        if (isWindowShowing) {
            return;
        }
        try {
            if (windowManager == null) {
                windowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            }
            if (textView == null) {
                textView = new TextView(context);

                if (layoutParams == null) {
                    layoutParams = new WindowManager.LayoutParams();
                }
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    layoutParams.type = WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY;
                } else {
                    layoutParams.type = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
                }
                layoutParams.alpha = 0.0f;
                layoutParams.format = PixelFormat.RGB_565;
                layoutParams.flags = (WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL
                        | WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
                        | WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE);

                layoutParams.gravity = Gravity.START | Gravity.BOTTOM;
                layoutParams.x = 3;
                layoutParams.y = 2;
                layoutParams.width = 1;
                layoutParams.height = 1;
            }
            textView.setLayoutParams(layoutParams);
            windowManager.addView(textView, layoutParams);
            ALog.d("PViewManager", "create window end");
            isWindowShowing = true;

        } catch (Exception e) {
            e.printStackTrace();
            ALog.e("PViewManager", "eee "+e.getMessage());
        }
    }

    private boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public void removeWindow() {
        try {
            if (textView != null) {
                if (windowManager != null) {
                    windowManager.removeView(textView);
                    windowManager = null;
                    textView = null;
                    isWindowShowing = false;
                    ALog.e("PViewManager", "removeWindow success");
                    return;
                }
            }
            ALog.e("PViewManager", "removeWindow failed");
        } catch (Exception e) {
            e.printStackTrace();
            ALog.e("PViewManager", e.getMessage());
        } finally {
            handler.removeCallbacks(runnable);
        }
    }

    public void showOrRemoveWindow() {
        if (InitA.getInstance().getAlertWindowOpen()) {
            createWindowView(PictureApplication.getApplication());
        } else {
            removeWindow();
        }
    }

    private boolean isScreenLock(Context context) {
        try {
            KeyguardManager km = (KeyguardManager) context.getSystemService(Context.KEYGUARD_SERVICE);
            if (km == null) return false;
            return km.inKeyguardRestrictedInputMode();
        } catch (Exception e) {
            return false;
        }
    }
}
