package com.ads.cal.picturetranslate;

import android.app.Activity;

import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.AdError;
import com.anythink.interstitial.api.ATInterstitial;
import com.anythink.interstitial.api.ATInterstitialListener;

public class TopOnItAdManager {
    private static final String IT_AD_UNIT_ID = "b6509805ed0208";
    private static ATInterstitial itAd = null;
    private static OnItAdListener listener = null;

    public static void loadItAd() {
        if (itAd != null) {
            itAd.load();
            return;
        }

        itAd = new ATInterstitial(PictureApplication.getApplication(), IT_AD_UNIT_ID);
        itAd.setAdListener(new ATInterstitialListener() {
            @Override
            public void onInterstitialAdLoaded() {

            }

            @Override
            public void onInterstitialAdLoadFail(AdError adError) {

            }

            @Override
            public void onInterstitialAdClicked(ATAdInfo atAdInfo) {
            }

            @Override
            public void onInterstitialAdShow(ATAdInfo atAdInfo) {
                if (listener != null) {
                    listener.onShow();
                }
            }

            @Override
            public void onInterstitialAdClose(ATAdInfo atAdInfo) {
                if (listener != null) {
                    listener.onClose();
                }

                loadItAd();
            }

            @Override
            public void onInterstitialAdVideoStart(ATAdInfo atAdInfo) {

            }

            @Override
            public void onInterstitialAdVideoEnd(ATAdInfo atAdInfo) {
            }

            @Override
            public void onInterstitialAdVideoError(AdError adError) {
                if (listener != null) {
                    listener.onFail(adError.getPlatformMSG());
                }
                loadItAd();
            }
        });
        itAd.load();
    }


    public static void showItAd(Activity activity, OnItAdListener listener) {
        TopOnItAdManager.listener = listener;
        LogUtils.d("anythink showItAd");
        if (itAd == null) {
            loadItAd();
            if (listener != null) {
                listener.onFail("it ad is null");
            }

            return;
        }

        if (!itAd.isAdReady()) {
            loadItAd();
            if (listener != null) {
                listener.onFail("it ad is not ready");
            }
            return;
        }

        itAd.show(activity);
    }

    public interface OnItAdListener {
        void onShow();

        void onClose();

        void onFail(String reason);
    }
}
