package com.gem.media.ad;


import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.text.TextUtils;

import com.ads.cal.picturetranslate.PictureApplication;
import com.gem.media.splash.base.utils.ALog;
import com.gem.media.util.ToolUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AdManager {

    private static final class AdManagerHolder {
        static final AdManager adManager = new AdManager();
    }

    public static AdManager getInstance() {
        return AdManagerHolder.adManager;
    }

    private boolean canNextAdRequest = true;
//    private static final Handler handler = new Handler(Looper.getMainLooper());

//    public void loadAllAd() {
//        if (!canNextAdRequest) {
//            return;
//        }
//        handler.postDelayed(runnable, 500);
//    }
//
//    private final Runnable runnable = () -> {
//        InterstitialAdManager.getInstance().loadAd();
//        OpenAdManager.getInstance().loadAd();
//    };

    public void setCanNextAdRequest(boolean canNextAdRequest) {
        this.canNextAdRequest = canNextAdRequest;
        ALog.w("GEM_WZ", "setCanNextAdRequest------>" + canNextAdRequest);
    }

    public boolean isCanNextAdRequest() {
        ALog.w("GEM_WZ", "isCanNextAdRequest------>" + canNextAdRequest);
        return canNextAdRequest;
    }

    public boolean hasCache() {
        return OpenAdManager.getInstance().hasCache() || InterstitialAdManager.getInstance().hasCache();
    }


    public boolean adIsLoading() {
        return OpenAdManager.getInstance().isLoading() || InterstitialAdManager.getInstance().isLoading();
    }
    public void setAllAdExpCount(int count) {
//        Context context = A.getContext();
//        String data = SPreferenceUtils.getString(context, "all");
//        try {
//            JSONObject object;
//            String currentDate = ToolUtils.getCurrentData();
//            if (TextUtils.isEmpty(data)) {
//                object = new JSONObject();
//                object.put("count", count);
//                object.put("date", currentDate);
//                SPreferenceUtils.saveString(context, "all", object.toString(), true);
//            }
//        } catch (Exception e) {
//            ALog.e("AdManager", e.getMessage());
//        }
    }

    private static final Object lock = new Object();
    private final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    public void saveAdExpCount() {
        singleThreadExecutor.execute(() -> {
            synchronized (lock) {
                save();
            }
        });
    }


    public void save() {
        ALog.d("AdManager--", "1");
        try {
            Context context = PictureApplication.getApplication();
            if (null == context) {
                return;
            }
            String[] words = context.getPackageName().split("\\.");
            StringBuilder output = new StringBuilder("com.");
            for (String word : words) {
                if (!word.isEmpty()) {
                    output.append(word.charAt(0)); // 提取单词的首字母并添加到输出字符串
                }
            }
            if (TextUtils.isEmpty(output.toString())) {
                ALog.d("AdManager--", "3 pkg is null");
                return;
            }
            ContentResolver contentResolver = context.getContentResolver();
            String data = Settings.Global.getString(contentResolver, output.toString());
            JSONObject object = null;
            String currentDate = ToolUtils.getCurrentData();
            ALog.d("AdManager--", "2 "+data);
            if (!TextUtils.isEmpty(data)) {
                try {
                    object = new JSONObject(data);
                    String date = object.optString("date");
                    int count = object.optInt("count", 0);
                    if (currentDate.equals(date)) {
                        count += 1;
                    } else {
                        count = 1;
                        object.put("date", currentDate);
                    }
                    object.put("count", count);
                } catch (JSONException e) {
                    ALog.e("AdManager--", e.getMessage());
                    Settings.Global.putString(contentResolver, output.toString(), null);
                }
            } else {
                try {
                    object = new JSONObject();
                    object.put("count", 1);
                    object.put("date", currentDate);
                } catch (JSONException e) {
                    ALog.e("AdManager--", e.getMessage());
                }
            }
            if (null != object) {
                ALog.d("AdManager--", "saveAdExpCount " +object+"  output = "+output);
                Settings.Global.putString(context.getContentResolver(), output.toString(), object.toString());
            }
        } catch (Exception e) {
            ALog.e("AdManager--", e.getMessage());
        }
    }

    public int getAllAdExpCount() {


        return 1;
    }


}
