package com.gem.media;

import static com.gem.media.splash.base.protocol.Constants.PROCESS_RESTART_AD_REQ_CALLBACK;

import com.ads.cal.picturetranslate.PictureApplication;
import com.gem.media.splash.base.utils.ALog;

import java.util.HashMap;
import java.util.Map;

public class AdReqHasCallBackUtil {

    private static final String KEY = "st";

    /**
     * 检查进程启动后广告上次一请求有没有完成
     */
    public static void checkAdReqHasCallBack() {
        long value = SPreferenceUtils.getLong(PictureApplication.getApplication(), "st");
        ALog.d("AdReqHasCallBackUtil", "values --- " + value);
        if (value != -1) {
            long time = System.currentTimeMillis() - value;
            Map<String, String> map = new HashMap<>();
            map.put("time", String.valueOf(time));
            map.put("c_time", System.currentTimeMillis() + "");
            StatsStaticHelper.onEvent(PROCESS_RESTART_AD_REQ_CALLBACK, map);
            setValue(-1);
        }
    }

    public static void setValue(long value) {
        ALog.d("AdReqHasCallBackUtil", "setValue --- " + value);
        SPreferenceUtils.saveLong(PictureApplication.getApplication(), KEY, value, true);
    }

}
