package com.gem.media.splash.base.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtil {
    public static void flush(InputStream inputStream, OutputStream outputStream) throws Throwable {
        flush(inputStream, outputStream, 8);
    }

    public static void flush(InputStream inputStream, OutputStream outputStream, int bufferSize) throws Throwable {
        byte[] buffer = new byte[1024 * bufferSize];
        int length;
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.flush();
    }

    public static byte[] getBytes(InputStream inputStream) throws Throwable {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            flush(inputStream, outputStream);
            return outputStream.toByteArray();
        } finally {
            CloseUtil.close(outputStream);
        }
    }

    public static String getString(InputStream inputStream) throws Throwable {
        return new String(getBytes(inputStream));
    }
}
