package com.gem.media;

import android.content.Context;
import android.content.SharedPreferences;

public class SPreferenceUtils {
    private static final String PRE_NAME = "media_pref_db";

    public static void saveString(Context context, String key, String value, boolean commit) {
        SharedPreferences preferences = context.getSharedPreferences(PRE_NAME, Context.MODE_PRIVATE);
        if (commit) {
            preferences.edit().putString(key, value).commit();
        } else {
            preferences.edit().putString(key, value).apply();
        }
    }

    public static String getString(Context context, String key) {
        SharedPreferences preferences = context.getSharedPreferences(PRE_NAME, Context.MODE_PRIVATE);
        return preferences.getString(key, "");
    }

    public static void saveLong(Context context, String key, long value, boolean commit) {
        SharedPreferences preferences = context.getSharedPreferences(PRE_NAME, Context.MODE_PRIVATE);
        if (commit) {
            preferences.edit().putLong(key, value).commit();
        } else {
            preferences.edit().putLong(key, value).apply();
        }
    }

    public static long getLong(Context context, String key) {
        SharedPreferences preferences = context.getSharedPreferences(PRE_NAME, Context.MODE_PRIVATE);
        return preferences.getLong(key, -1);
    }

    public static void saveInt(Context context, String key, int value, boolean commit) {
        SharedPreferences preferences = context.getSharedPreferences(PRE_NAME, Context.MODE_PRIVATE);
        if (commit) {
            preferences.edit().putInt(key, value).commit();
        } else {
            preferences.edit().putInt(key, value).apply();
        }
    }

    public static int getInt(Context context, String key) {
        SharedPreferences preferences = context.getSharedPreferences(PRE_NAME, Context.MODE_PRIVATE);
        return preferences.getInt(key, -1);
    }





}
