package com.gem.media;

import android.content.Context;
import android.text.TextUtils;

import com.ads.cal.picturetranslate.PictureApplication;
import com.gem.media.splash.base.utils.ALog;
import com.or.ange.dot.UsageStats;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class RestartAndOnlineTimeStaticsHelper {
    private static final String KEY = "app_restart_count";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static void setRestartCount() {
        String obj = SPreferenceUtils.getString(PictureApplication.getApplication(), KEY);
        String dateNow = simpleDateFormat.format(System.currentTimeMillis());
        if (!TextUtils.isEmpty(obj)) {
            try {
                JSONObject object = new JSONObject(obj);
                String date = object.optString("date");
                int count = object.optInt("count", -1);
                if (!TextUtils.isEmpty(date) && !TextUtils.isEmpty(dateNow)) {
                    if (dateNow.equals(date)) {
                        count += 1;
                        object.put("count", count);
                        ALog.e("RestartAndOnlineTimeStaticsHelper", object.toString());
                        SPreferenceUtils.saveString(PictureApplication.getApplication(), KEY, object.toString(), true);
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            JSONObject object = new JSONObject();
            try {
                object.put("count", 0);
                object.put("date", dateNow);
                object.put("ol_time", 0);
                SPreferenceUtils.saveString(PictureApplication.getApplication(), KEY, object.toString(), true);
            } catch (JSONException e) {
                e.printStackTrace();
            }

        }
    }

    public static void checkOnLineTime(int time) {
        String obj = SPreferenceUtils.getString(PictureApplication.getApplication(), KEY);
        String dateNow = simpleDateFormat.format(System.currentTimeMillis());
        if (!TextUtils.isEmpty(obj)) {
            try {
                JSONObject object = new JSONObject(obj);
                String date = object.optString("date");
                int count = object.optInt("count", -1);
                int ol_time = object.optInt("ol_time");
                if (!TextUtils.isEmpty(date) && !TextUtils.isEmpty(dateNow)) {
                    if (!dateNow.equals(date)) {
                        reportOnlineTime(ol_time);
                        reportRestart(count);
                        object.put("count", -1);
                        object.put("date", dateNow);
                        object.put("ol_time", 0);
                    } else {
                        object.put("ol_time", ol_time + time);
                    }
                    SPreferenceUtils.saveString(PictureApplication.getApplication(), KEY, object.toString(), true);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            JSONObject object = new JSONObject();
            try {
                object.put("count", 0);
                object.put("date", dateNow);
                object.put("ol_time", time);
                SPreferenceUtils.saveString(PictureApplication.getApplication(), KEY, object.toString(), true);
            } catch (JSONException e) {
                e.printStackTrace();
            }

        }
    }

    private static void reportOnlineTime(int time) {
        Map<String, String> map = new HashMap<>();
        map.put("lv_time", String.valueOf(time));
        map.put("uuid", InitA.getInstance().getUuid());

        ALog.e("RestartAndOnlineTimeStaticsHelper", "reportOnlineTime = " + time);
        StatsStaticHelper.onEvent("br_lv_one_day", map);
    }


    private static void reportRestart(int count) {
        Map<String, String> map = new HashMap<>();
        map.put("count", String.valueOf(count));
        map.put("uuid", InitA.getInstance().getUuid());
        ALog.e("RestartAndOnlineTimeStaticsHelper", "reportRestart = " + count);
        StatsStaticHelper.onEvent("app_restart_count", map);
    }
}
