package com.gem.media.ad;

import android.text.TextUtils;

import com.anythink.core.api.ATSDK;
import com.gem.media.splash.base.utils.ALog;
import com.gem.media.splash.base.utils.PROP;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AdData {

    public static final String AD_TYPE_OPEN = "kaipin";
    public static final String AD_TYPE_INTERSTITIAL = "chapin";
    public static final String AD_TYPE_NATIVE = "yuansheng";
    public static final String AD_TYPE_HALF_INTERSTITIAL = "halfChapin";

    public String appId;
    public List<String> adTypes;
    public HashMap<String, List<String>> mapHashMap = new HashMap<>();


    public void setAppId(String appId) {
        this.appId = appId;
    }


    public void setAdType(String adType) {
        if (null == adTypes) {
            adTypes = new ArrayList<>();
        }
        if (adTypes.isEmpty()) {
            adTypes.add(adType);
        } else {
            if (!adTypes.contains(adType)) {
                adTypes.add(adType);
            }
        }
    }

    public void addData(String adType, String adId) {
        if (null == mapHashMap){
            mapHashMap = new HashMap<>();
        }
        List<String> data = mapHashMap.get(adType);
        if (data == null) {
            data = new ArrayList<>();
            data.add(adId);
            mapHashMap.put(adType, data);
        } else {
            if (!data.contains(adId)) {
                data.add(adId);
            }
        }
    }

    public boolean hasAdData() {
        if (mapHashMap == null || mapHashMap.isEmpty()) {
            return false;
        }
        if (adTypes.isEmpty()) {
            return false;
        }
        boolean hasAdData = false;
        for (String type : adTypes) {
            List<String> data = mapHashMap.get(type);
            hasAdData = (data != null && !data.isEmpty());
            if (!hasAdData) {
                break;
            }
        }
        return hasAdData;
    }

    public String getAdAdId(String adType) {
        ALog.w("GEM_WZ", "   getAdAdId   == " + mapHashMap);
        if (mapHashMap == null || mapHashMap.isEmpty()) {
            return "";
        }
        List<String> data = mapHashMap.get(adType);
        if (data == null || data.isEmpty()) {
            return "";
        }
        return data.get(0);
    }

    public boolean canLoadAdData(String adType) {
        boolean can = false;
        if (null == adTypes) {
            adTypes = new ArrayList<>();
            ALog.w("GEM_WZ", " canLoadAdData  adTypes   ==  null");
            return false;
        }
        if (TextUtils.isEmpty(adType)) {
            return false;
        }
        ALog.w("GEM_WZ", " canLoadAdData  adTypes size == " +adTypes.size());
        for (String type : adTypes) {
            ALog.w("GEM_WZ", " canLoadAdData  adTypes type == " +type +"   "+adType);
            if (!TextUtils.isEmpty(type) && type.equals(adType)) {
                can = true;
                break;
            }
        }
        return can;
    }

}
