package com.android.gem.core;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.Map;

public class ReportBean implements Parcelable {
    private Map<String, String> data;
    private String type;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public ReportBean() {

    }

    protected ReportBean(Parcel in) {
        data = in.readHashMap(String.class.getClassLoader());  // 读取 Map 数据
        type = in.readString();  // 读取 String 类型数据
    }

    public static final Creator<ReportBean> CREATOR = new Creator<ReportBean>() {
        @Override
        public ReportBean createFromParcel(Parcel in) {
            return new ReportBean(in);
        }

        @Override
        public ReportBean[] newArray(int size) {
            return new ReportBean[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeMap(data);  // 写入 Map 数据
        dest.writeString(type);  // 写入 String 类型数据
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public Map<String, String> getData() {
        return data;
    }
}
