package com.ads.cal.picturetranslate.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.ads.cal.picturetranslate.R;
import com.ads.cal.picturetranslate.activity.AboutActivity;

public class SettingFragment extends Fragment {

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return initView(inflater);
    }

    private View initView(LayoutInflater inflater) {
        View view = inflater.inflate(R.layout.fragment_setting, null, false);
        RelativeLayout share_layout = view.findViewById(R.id.share_layout);
        RelativeLayout email_layout = view.findViewById(R.id.email_layout);
        RelativeLayout policy_layout = view.findViewById(R.id.policy_layout);
        RelativeLayout about_layout = view.findViewById(R.id.about_layout);
        share_layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent shareIntent = new Intent(Intent.ACTION_SEND);
                shareIntent.setType("text/plain");
                shareIntent.putExtra(Intent.EXTRA_TEXT, "分享内容"); // 设置要分享的内容
                startActivity(Intent.createChooser(shareIntent, "分享到"));
            }
        });
        email_layout.setOnClickListener(v -> {
            // 创建一个Intent，指定Action为发送邮件
            Intent emailIntent = new Intent(Intent.ACTION_SEND);
            // 设置邮件的类型为“text/plain”
            emailIntent.setType("text/plain");
            // 添加收件人（可选）
            emailIntent.putExtra(Intent.EXTRA_EMAIL, new String[]{"zl@cc.com"});

            // 启动邮件客户端
            startActivity(Intent.createChooser(emailIntent, "选择邮件客户端"));
        });
        policy_layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
        about_layout.setOnClickListener(v -> AboutActivity.startAboutActivity(getContext()));
        return view;
    }
}
