package com.gem.media.splash.base.utils;

public class PROP {

    private static final String TAG = "PROP";

    /**
     * 是否打开日志
     * debug.kw.s1.log
     */
    public static boolean isLogEnabled() {
        try {
            return readPropertyAsInt("debug.out.s1.log", 0) != 0;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 获取系统属性
     *
     * @param key          对应关键字
     * @param defaultValue 默认值
     * @return 系统属性值
     */
    public static int readPropertyAsInt(String key, int defaultValue) {
        return SystemPropertiesReflector.getInt(key, defaultValue);
    }

    /**
     * 获取系统属性
     *
     * @param key          对应关键字
     * @param defaultValue 默认值
     * @return 系统属性值
     */
    public static String readProperty(String key, String defaultValue) {
        return SystemPropertiesReflector.get(key, defaultValue);
    }
}
