package com.gem.media;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;

import com.ads.cal.core.InitClean;
import com.ads.cal.core.ListenerHelper.AdListenerHelper;
import com.ads.cal.core.ListenerHelper.CleanReportInterface;
import com.ads.cal.core.ListenerHelper.SettingListenerHelper;
import com.ads.cal.core.data.JumpInfo;
import com.ads.cal.core.data.ReportInfo;
import com.ads.cal.picturetranslate.PictureApplication;
import com.ads.cal.picturetranslate.R;
import com.ads.cal.picturetranslate.activity.PictureTranslateResultActivity;
import com.ads.cal.picturetranslate.activity.PictureTranslateShowPhotoActivity;
import com.gem.media.ad.AdManager;
import com.gem.media.ad.InterstitialAdManager;
import com.gem.media.ad.NativeAdClearManager;
import com.gem.media.splash.base.protocol.Constants;
import com.gem.media.splash.base.utils.ALog;
import com.gem.media.splash.base.utils.PkgUtils;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.or.ange.dot.utils.LLog;
import com.thinkup.nativead.api.TUNativeView;

public class CleanUtil {

    public static void init(Application application) {
        InitClean.init(application, (context, jumpType, jumpInfo) -> {
            if (InitA.getInstance().isAppBackground()) {
                return;
            }
            Bundle bundle = new Bundle();
            String jumpTypeString = getJumpTypeString(jumpType);
            if (jumpType == JumpInfo.JUMP_ACTIVITY_CLEAN_SCAN || jumpType == JumpInfo.JUMP_ACTIVITY_PROCESS_SCAN) {
                PictureTranslateShowPhotoActivity.startPictureTranslateShowPhotoActivity(context, jumpInfo, jumpType);
                bundle.putString("jumpType", jumpTypeString);
            } else {
                if (jumpType == JumpInfo.JUMP_CLEAN_RESULT || jumpType == JumpInfo.JUMP_PROCESS_RESULT) {
                    loadChaPinAd();
                }
                startAudioDetailPageIfPossible(context, jumpInfo, jumpType);
                bundle.putString("jumpType", jumpTypeString);
            }
            try {
                Messenger messenger = InitA.getInstance().getCleanMessenger();
                if (messenger != null) {
                    Message message = Message.obtain();
                    message.what = 20003;
                    if (jumpInfo != null) {
                        bundle.putString("event", "cleanJump");
                        bundle.putString("pageName", jumpInfo.pageName);
                        String pkgName = PictureApplication.getApplication().getPackageName();
                        bundle.putString(Constants.MEDIA_PKG, pkgName);
                        bundle.putString("vn", PkgUtils.getAppVersionName(PictureApplication.getApplication(), pkgName));
                        bundle.putString("vc", PkgUtils.getAppVersionCode(PictureApplication.getApplication(), pkgName));
                    }
                    message.setData(bundle);
                    messenger.send(message);
                }
            } catch (Exception e) {
                ALog.e("AudioEditorInit", Log.getStackTraceString(e));
            }
        });
        try {
            setStopProcess();
        } catch (Exception e) {

        }
        try {
            setAdInterstitialDisplay();
        } catch (Exception e) {

        }
        try {
            setSettingHelper();
        } catch (Exception e) {

        }
        try {
            setAdNativeDisplay();
        } catch (Exception e) {

        }
        try {
            report();
        } catch (Exception e) {

        }
    }

    private static String getJumpTypeString(int jumpType) {
        switch (jumpType) {
            case JumpInfo.JUMP_ACTIVITY_CLEAN_SCAN:
                return "junk";
            case JumpInfo.JUMP_ACTIVITY_PROCESS_SCAN:
                return "process";
            case JumpInfo.JUMP_CLEAN_RESULT:
                return "junkResult";
            case JumpInfo.JUMP_PROCESS_RESULT:
                return "processResult";
            case JumpInfo.JUMP_CLEAN_SCAN_DETAILED:
                return "junkScanResult";
            case JumpInfo.JUMP_PROCESS_SCAN_DETAILED:
                return "processScanResult";
            default:
                return "unknown";
        }
    }

    private static void loadChaPinAd() {
        try {
            if (!InterstitialAdManager.getInstance().hasCache()) {
                InterstitialAdManager.getInstance().loadAd();
            }
        } catch (Exception e) {
            //
        }
    }

    private static void setStopProcess() {
        InitClean.INSTANCE.setStopProcessListener((s, stopProcessCallback) -> {
            try {
                Messenger messenger = InitA.getInstance().getCleanMessenger();
                ALog.e("AudioEditorInit", "pkg  " + s + "  messenger " + messenger);
                if (messenger != null) {
                    Message message = Message.obtain();
                    message.what = 20001;
                    messenger.send(message);
                }
            } catch (Exception e) {
                ALog.e("AudioEditorInit", Log.getStackTraceString(e));
            } finally {
                if (null != stopProcessCallback) {
                    stopProcessCallback.stopProcessSuccess();
                }
            }
        });
    }

    private static void setAdInterstitialDisplay() {
        InitClean.INSTANCE.setAdInterstitialDisplayListener(new AdListenerHelper.AdInterstitialDisplayListener() {
            @Override
            public void showAd(Context context, String scenario, AdListenerHelper.AdShownCallback adShownCallback) {
                InitA.getInstance().setAdShownCallback(adShownCallback);
                if (adShownCallback != null) {
                    if (InterstitialAdManager.getInstance().hasCache()) {
                        if (context instanceof Activity) {
                            InterstitialAdManager.getInstance().showAd((Activity) context, scenario);
                        } else {
                            adShownCallback.onAdCompleted();
                        }
                    } else {
                        adShownCallback.onAdCompleted();
                    }
                }
            }

            @Override
            public void loadAd() {
                LLog.e("AudioEditorInit", "22222  "+InterstitialAdManager.getInstance().hasCache());
                if (!InterstitialAdManager.getInstance().hasCache()) {
                    InterstitialAdManager.getInstance().loadAd();
                } else {
                    try {
                        Messenger messenger = InitA.getInstance().getCleanMessenger();
                        if (messenger != null) {
                            Message message = Message.obtain();
                            message.what = 20003;
                            Bundle bundle = new Bundle();
                            bundle.putString("event", "cl_AdCache");
                            String pkgName = PictureApplication.getApplication().getPackageName();
                            bundle.putString(Constants.MEDIA_PKG, pkgName);
                            bundle.putString("vn", PkgUtils.getAppVersionName(PictureApplication.getApplication(), pkgName));
                            bundle.putString("vc", PkgUtils.getAppVersionCode(PictureApplication.getApplication(), pkgName));
                            message.setData(bundle);
                            messenger.send(message);
                        }
                    } catch (Exception e) {
                        ALog.e("AudioEditorInit", Log.getStackTraceString(e));
                    }
                }
            }
        });
    }

    private static void setSettingHelper() {
        InitClean.INSTANCE.setSettingListenerHelper(new SettingListenerHelper() {
            @Override
            public void setCleanReminderStatus(int type, boolean b) {
                try {
                    Messenger messenger = InitA.getInstance().getCleanMessenger();
                    if (messenger != null) {
                        Message message = Message.obtain();
                        message.what = 20004;
                        Bundle bundle = new Bundle();
                        bundle.putInt("type", type);
                        bundle.putBoolean("value", b);
                        message.setData(bundle);
                        messenger.send(message);
                    }
                } catch (Exception e) {
                    ALog.e("AudioEditorInit", Log.getStackTraceString(e));
                }
            }
        });
    }

    private static void setAdNativeDisplay() {
        InitClean.INSTANCE.setAdNativeDisplayListener(new AdListenerHelper.AdNativeDisplayListener() {
            @Override
            public void showAd(Context context, String adPosition, String s1, AdListenerHelper.AdNativeShownCallback adNativeShownCallback) {
                ALog.e("AudioEditorInit", "setAdNativeDisplayListener   1");
                if (adNativeShownCallback != null) {
                    try {
                        InitA.getInstance().setAdNativeShownCallback(adNativeShownCallback);
                        LLog.e("AudioEditorInit", "setAdNativeDisplayListener   2");
                        NativeAdClearManager nativeAdClearManager = AdManager.getInstance().getNativeManager(adPosition);
                        if (nativeAdClearManager.isNativeAdReady()) {
                            LLog.e("AudioEditorInit", "setAdNativeDisplayListener   4");
                            if (context instanceof Activity) {
                                TUNativeView view = (TUNativeView) LayoutInflater.from(context).inflate(R.layout.view_native_ad_layout, null);
                                LLog.e("AudioEditorInit", "setAdNativeDisplayListener   5 " + view);
                                showNativeView(nativeAdClearManager, view);
                                adNativeShownCallback.onAdCompleted(view, nativeAdClearManager.getAdPosition());
                            } else {
                                adNativeShownCallback.onAdCompleted(null, nativeAdClearManager.getAdPosition());
                            }
                        } else {
                            adNativeShownCallback.onAdCompleted(null, nativeAdClearManager.getAdPosition());
                        }
                    } catch (Exception e) {
                        LLog.e("AudioEditorInit", "setAdNativeDisplayListener  " + Log.getStackTraceString(e));
                    }
                }
            }

            @Override
            public void loadAd(String adPosition) {
                NativeAdClearManager nativeAdClearManager = AdManager.getInstance().getNativeManager(adPosition);
                LLog.e("AudioEditorInit", "load native   1"+" cache "+nativeAdClearManager.isNativeAdReady());

                if (!nativeAdClearManager.isNativeAdReady()) {
                    nativeAdClearManager.loadAd();
                }
            }
        });
    }

    private static void report() {
        InitClean.INSTANCE.setCleanReportInterfaceHelper(new CleanReportInterface() {
            @Override
            public void report(ReportInfo reportInfo) {
                if (null == reportInfo) {
                    return;
                }
                Bundle bundle = new Bundle();
                try {
                    String event = reportInfo.event;
                    if (!TextUtils.isEmpty(event)) {
                        bundle.putString("event", reportInfo.event);
                    }
                    String pageName= reportInfo.pageName;
                    if (!TextUtils.isEmpty(pageName)) {
                        bundle.putString("pageName", pageName);
                    }
                    String rate = reportInfo.rate;
                    if (!TextUtils.isEmpty(rate)) {
                        bundle.putString("rate", rate);
                    }
                    String cleanType = reportInfo.cleanType;
                    if (!TextUtils.isEmpty(cleanType)) {
                        bundle.putString("cleanType", cleanType);
                    }
                    String pkgName = PictureApplication.getApplication().getPackageName();
                    bundle.putString(Constants.MEDIA_PKG, pkgName);
                    bundle.putString("vn", PkgUtils.getAppVersionName(PictureApplication.getApplication(), pkgName));
                    bundle.putString("vc", PkgUtils.getAppVersionCode(PictureApplication.getApplication(), pkgName));
                } catch (Exception e) {
                    //
                }
                try {
                    Messenger messenger = InitA.getInstance().getCleanMessenger();
                    if (messenger != null) {
                        Message message = Message.obtain();
                        message.what = 20003;
                        message.setData(bundle);
                        messenger.send(message);
                    }
                } catch (Exception e) {
                    LLog.e("AudioEditorInit", Log.getStackTraceString(e));
                }
            }
        });
    }

    private static void startAudioDetailPageIfPossible(Context context, JumpInfo jumpInfo, int jumpType) {
        if (context instanceof Activity) {
            try {
                PictureTranslateResultActivity.start((Activity) context, jumpInfo, jumpType);
            } catch (Exception e) {
                //
            }
        }
    }

    public static void showNativeView(NativeAdClearManager manager, View view) {
        try {
            TUNativeView atNativeView = view.findViewById(R.id.native_ad_view);
            ALog.e("AudioEditorInit", "atNativeView  "+atNativeView+"  cache   "+manager.isNativeAdReady());
            if (manager.isNativeAdReady()) {
                View mSelfRenderView = view.findViewById(R.id.native_selfrender_view);
                view.findViewById(R.id.native_ad_close).setVisibility(View.GONE);
                manager.showAd(atNativeView, mSelfRenderView);
                atNativeView.setVisibility(View.VISIBLE);
            } else {
                atNativeView.setVisibility(View.INVISIBLE);
            }
        } catch (Exception e) {
            ALog.e("AudioEditorInit", Log.getStackTraceString(e));
            //
        }
    }
}
