package com.ads.cal.picturetranslate;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;

import com.ads.cal.picturetranslate.db.DataBaseManager;
import com.gem.media.InitA;
//import com.google.android.gms.ads.MobileAds;
//import com.google.android.gms.ads.initialization.InitializationStatus;
//import com.google.android.gms.ads.initialization.OnInitializationCompleteListener

public class PictureApplication extends Application implements Application.ActivityLifecycleCallbacks, LifecycleObserver {

    private static DataBaseManager dataBaseManager;
    private static Application application;

    private static final int init = 0;
    @Override
    public void onCreate() {
        super.onCreate();
        application = this;
        if (init == 0) {
            InitA.getInstance().init(this);
            return;
        }
        this.registerActivityLifecycleCallbacks(this);
//        MobileAds.initialize(this, new OnInitializationCompleteListener() {
//            @Override
//            public void onInitializationComplete(@NonNull InitializationStatus initializationStatus) {
//                LogUtils.d("PictureApplication", "initializationStatus   " + initializationStatus.toString());
//            }
//        });

        ProcessLifecycleOwner.get().getLifecycle().addObserver(this);
        new Thread(() -> {
            PictureTranslateUtils.init();
        });

        initDB();

        TopOnManager.get().initSDK(this);
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_START)
    protected void onMoveToForeground() {
        // Show the ad (if available) when the app moves to foreground.
        if (init == 0) {
            return;
        }
        TopOnAppOpenAdManager.getInstance().showAdIfAvailable(currentActivity);
    }


    public static Application getApplication() {
        return application;
    }

    private void initDB() {
        dataBaseManager = new DataBaseManager(this);
        dataBaseManager.open();
    }

    public static DataBaseManager getDataBaseManager() {
        return dataBaseManager;
    }

    private Activity currentActivity;

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {

    }

    @Override
    public void onActivityStarted(@NonNull Activity activity) {
        if (!TopOnAppOpenAdManager.getInstance().isShowingAd()) {
            currentActivity = activity;
        }
    }

    @Override
    public void onActivityResumed(@NonNull Activity activity) {

    }

    @Override
    public void onActivityPaused(@NonNull Activity activity) {

    }

    @Override
    public void onActivityStopped(@NonNull Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {

    }
}
