/*
 * Decompiled with CFR 0.152.
 */
package cn.kw.lib.common;

import cn.kw.lib.common.Base64;
import cn.kw.lib.common.Zip;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AES {
    private static final String MODE = "AES/CFB/NoPadding";
    private static final byte[] IV = new byte[]{48, 49, 48, 50, 48, 51, 48, 52, 48, 53, 48, 54, 48, 55, 48, 56};

    public static String encryptGzString(String plain, String key) {
        try {
            byte[] encrypt = AES.encrypt(plain.getBytes("UTF-8"), key, new String(IV));
            byte[] gz = Zip.gz(encrypt);
            return Base64.encodeToString(gz, 2);
        }
        catch (Exception e) {
            return plain;
        }
    }

    public static String encryptGzString(String plain, String key, String iv) {
        try {
            byte[] encrypt = AES.encrypt(plain.getBytes("UTF-8"), key, iv);
            byte[] gz = Zip.gz(encrypt);
            return Base64.encodeToString(gz, 2);
        }
        catch (Exception e) {
            return plain;
        }
    }

    public static String encryptString(String plain, String key, String iv) {
        try {
            byte[] encrypt = AES.encrypt(plain.getBytes("UTF-8"), key, iv);
            return Base64.encodeToString(encrypt, 2);
        }
        catch (Exception e) {
            return plain;
        }
    }

    public static String encryptAsString(String plain, String key) {
        try {
            return Base64.encodeToString(AES.encrypt(plain, key), 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return plain;
        }
    }

    public static byte[] encrypt(String plain, String key) throws Exception {
        return AES.encrypt(plain.getBytes("UTF-8"), key, new String(IV));
    }

    public static byte[] encrypt(byte[] plain, String key, String iv) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] kb = md.digest(key.getBytes("UTF-8"));
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes("UTF-8"));
        SecretKeySpec spec = new SecretKeySpec(kb, "AES");
        Cipher cipher = Cipher.getInstance(MODE);
        cipher.init(1, (Key)spec, ivParameterSpec);
        return cipher.doFinal(plain);
    }

    public static String decryptGzString(String cipherText, String key) {
        try {
            byte[] decode = Base64.decode(cipherText, 2);
            byte[] ungz = Zip.ungz(decode);
            byte[] decrypt = AES.decrypt(ungz, key, new String(IV));
            return new String(decrypt, "US-ASCII");
        }
        catch (Exception e) {
            return cipherText;
        }
    }

    public static String decryptGzString(String cipherText, String key, String iv) {
        try {
            byte[] decode = Base64.decode(cipherText, 2);
            byte[] ungz = Zip.ungz(decode);
            byte[] decrypt = AES.decrypt(ungz, key, iv);
            return new String(decrypt, "US-ASCII");
        }
        catch (Exception e) {
            return cipherText;
        }
    }

    public static String decryptString(String cipherText, String key, String iv) {
        try {
            byte[] decode = Base64.decode(cipherText, 2);
            byte[] decrypt = AES.decrypt(decode, key, iv);
            return new String(decrypt, "US-ASCII");
        }
        catch (Exception e) {
            return cipherText;
        }
    }

    public static byte[] decrypt(String cipherText, String key) throws Exception {
        return AES.decrypt(cipherText.getBytes("UTF-8"), key, new String(IV));
    }

    public static String decryptAsString(String cipherText, String key) {
        try {
            return new String(AES.decrypt(Base64.decode(cipherText, 2), key, new String(IV)), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return cipherText;
        }
    }

    public static byte[] decrypt(byte[] cipherText, String key, String iv) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] kb = md.digest(key.getBytes("UTF-8"));
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes("UTF-8"));
        SecretKeySpec spec = new SecretKeySpec(kb, "AES");
        Cipher cipher = Cipher.getInstance(MODE);
        cipher.init(2, (Key)spec, ivParameterSpec);
        return cipher.doFinal(cipherText);
    }

    public static boolean overflow(String data, String key) {
        return data.length() * 4 / 3 >= Short.MAX_VALUE;
    }
}

