package com.ads.cal.picturetranslate.activity;

import static com.ads.cal.picturetranslate.SharedPreferencesUtil.KEY_FIRST_INSTALL_APP;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ExperimentalGetImage;

import com.ads.cal.picturetranslate.PictureTranslateUtils;
import com.ads.cal.picturetranslate.R;
import com.ads.cal.picturetranslate.SharedPreferencesUtil;
import com.ads.cal.picturetranslate.base.BaseActivity;

import java.io.IOException;
import java.lang.ref.WeakReference;

import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifImageView;

@ExperimentalGetImage
public class PictureTranslateStartActivity extends BaseActivity {

    private MyHandler handler;
    private ProgressBar bar;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_start);
        initView();
    }

    private void initView() {
        GifImageView imageView = findViewById(R.id.gifimg);
        try {
            GifDrawable gifFromAssets = new GifDrawable(getAssets(), "app_gif.gif");
            gifFromAssets.setLoopCount(1);
            imageView.setImageDrawable(gifFromAssets);
        } catch (IOException e) {
            e.printStackTrace();
        }

        bar = findViewById(R.id.horizontalProgressBar);
        TextView try_it_now = findViewById(R.id.try_it_now);
        String firstInstall = SharedPreferencesUtil.getString(this, KEY_FIRST_INSTALL_APP, "");
        if (!TextUtils.isEmpty(firstInstall)) {
            try_it_now.setVisibility(View.GONE);
            bar.setVisibility(View.VISIBLE);
            handler = new MyHandler(this);
            handler.sendEmptyMessage(1);
        } else {
            try_it_now.setOnClickListener(v -> {
                PictureTranslateListMainActivity.PictureTranslateListMainActivityStart(PictureTranslateStartActivity.this);
                SharedPreferencesUtil.saveString(PictureTranslateStartActivity.this, KEY_FIRST_INSTALL_APP, "install");
                finish();
            });
        }
    }

    public void setProgressBarProgress(int i) {
        if (i >= 100) {
            if (handler != null) {
                handler.removeCallbacksAndMessages(null);
            }
            PictureTranslateListMainActivity.PictureTranslateListMainActivityStart(this);
            finish();
            return;
        }
        bar.setProgress(i);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
    }

    private static class MyHandler extends Handler {

        private final WeakReference<Activity> weakReference;
        private int i = 0;

        public MyHandler(Activity activity) {
            super();
            weakReference = new WeakReference<>(activity);
        }

        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            sendEmptyMessageDelayed(1, 10);
            Activity activity = weakReference.get();
            if (activity instanceof PictureTranslateStartActivity) {
                ((PictureTranslateStartActivity) activity).setProgressBarProgress(i++);
            }
        }

    }
}
