package com.gem.media;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.ads.cal.picturetranslate.PictureApplication;
import com.or.ange.dot.utils.LLog;

public class SystemDialogReceiver extends BroadcastReceiver {

    private static final String TAG = "SystemEventMonitor";
    private static final String SYSTEM_DIALOG_REASON_KEY = "reason";
    private static final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";
    private static final String SYSTEM_DIALOG_REASON_RECENT_APPS = "recentapps";
    private static final int HOME_KEY_DEBOUNCE_DELAY = 300;
    private long lastHomeKeyTime = 0L;
    public static boolean toRecent = false;

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent.getAction() == null ||
                !intent.getAction().equals(Intent.ACTION_CLOSE_SYSTEM_DIALOGS)) {
            return;
        }

        String reason = intent.getStringExtra(SYSTEM_DIALOG_REASON_KEY);
        if (reason == null) return;

        switch (reason) {
            case SYSTEM_DIALOG_REASON_RECENT_APPS:
                toRecent = true;
            case SYSTEM_DIALOG_REASON_HOME_KEY:
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastHomeKeyTime > HOME_KEY_DEBOUNCE_DELAY) {
                    lastHomeKeyTime = currentTime;
                    InitA.getInstance().cleanTask(PictureApplication.getApplication(), 0);
                }
                break;
        }
        LLog.d(TAG, "检测到系统事件: " + reason);
    }
}
