/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot.utils;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.or.ange.dot.utils.LLog;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadManager {
    private static final String TAG = "ThreadManager";
    private static volatile ScheduledExecutorService gCoreScheduler = null;
    private static volatile ExecutorService gCoreExecutor = null;
    private static volatile ExecutorService gNormalExecutor = null;
    private static volatile ExecutorService gSingleExecutor = null;
    private static volatile Executor gMainExecutor = null;
    private static final Handler MAIN_HANDLER = new Handler(Looper.getMainLooper());

    public static synchronized ScheduledExecutorService getCoreScheduler() {
        if (null == gCoreScheduler) {
            int pid = Process.myPid();
            int tid = Process.myTid();
            LLog.i(TAG, "[" + pid + "][" + tid + "] init core scheduler executor ...");
            gCoreScheduler = new ScheduledThreadPoolExecutor(1);
        }
        return gCoreScheduler;
    }

    public static synchronized ExecutorService getCoreExecutor() {
        if (null == gCoreExecutor) {
            int pid = Process.myPid();
            int tid = Process.myTid();
            LLog.i(TAG, "[" + pid + "][" + tid + "] init core executor ...");
            gCoreExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return gCoreExecutor;
    }

    public static synchronized ExecutorService getNormalExecutor() {
        if (null == gNormalExecutor) {
            int pid = Process.myPid();
            int tid = Process.myTid();
            LLog.i(TAG, "[" + pid + "][" + tid + "] init normal executor ...");
            gNormalExecutor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return gNormalExecutor;
    }

    public static synchronized ExecutorService getSingleExecutor() {
        if (null == gSingleExecutor) {
            int pid = Process.myPid();
            int tid = Process.myTid();
            LLog.i(TAG, "[" + pid + "][" + tid + "] init single executor ...");
            gSingleExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return gSingleExecutor;
    }

    public static synchronized Executor getMainExecutor() {
        if (gMainExecutor == null) {
            gMainExecutor = new Executor(){

                @Override
                public void executeDelay(Runnable command, long delayMills) {
                    MAIN_HANDLER.postDelayed(command, delayMills);
                }

                @Override
                public void execute(Runnable command) {
                    MAIN_HANDLER.post(command);
                }
            };
        }
        return gMainExecutor;
    }

    public static interface Executor
    extends java.util.concurrent.Executor {
        public void executeDelay(Runnable var1, long var2);
    }
}

