package com.ads.cal.picturetranslate;

import android.app.Application;

import com.ads.cal.picturetranslate.db.DataBaseManager;

public class PictureApplication extends Application {

    private static DataBaseManager dataBaseManager;
    private static Application application;

    @Override
    public void onCreate() {
        super.onCreate();
        application = this;
        new Thread(() -> {
            PictureTranslateUtils.init();
        });
        initDB();

    }

    public static Application getApplication() {
        return application;
    }

    private void initDB() {
        dataBaseManager = new DataBaseManager(this);
        dataBaseManager.open();
    }

    public static DataBaseManager getDataBaseManager() {
        return dataBaseManager;
    }
}
