package com.gem.media.splash.base.utils;

import java.lang.reflect.Method;

public final class SystemPropertiesReflector {

    private SystemPropertiesReflector() {
    }

    private static Class SYSTEM_PROPERTIES_CLASS;

    static {
        try {
            SYSTEM_PROPERTIES_CLASS = Class.forName("android.os.SystemProperties");
        } catch (ClassNotFoundException e) {
        }
    }
    private static Method sGetStringWithDefault;
    private static Method sSetStringWithDefault;
    private static Method sGetBooleanWithDefault;
    private static Method sGetIntegerWithDefault;

    public static String get(String key, String def) {
        try {
            if (sGetStringWithDefault == null) {
                synchronized (SystemPropertiesReflector.class) {
                    if (sGetStringWithDefault == null) {
                        sGetStringWithDefault = SYSTEM_PROPERTIES_CLASS.getDeclaredMethod("get", new Class[]{String.class, String.class});
                        sGetStringWithDefault.setAccessible(true);
                    }
                }
            }

            Object value = sGetStringWithDefault.invoke(SYSTEM_PROPERTIES_CLASS, key, def);
            if (value == null) {
                return def;
            }
            return value.toString();
        } catch (Exception e) {
        }
        return def;
    }

    public static void set(String key, String value) {
        try {
            if (sSetStringWithDefault == null) {
                synchronized (SystemPropertiesReflector.class) {
                    if (sSetStringWithDefault == null) {
                        sSetStringWithDefault = SYSTEM_PROPERTIES_CLASS.getDeclaredMethod("set", new Class[]{String.class, String.class});
                        sSetStringWithDefault.setAccessible(true);
                    }
                }
            }
            sSetStringWithDefault.invoke(SYSTEM_PROPERTIES_CLASS, key, value);
        } catch (Exception e) {
        }
    }

    public static boolean getBoolean(String key, boolean def) {
        try {
            if (sGetBooleanWithDefault == null) {
                synchronized (SystemPropertiesReflector.class) {
                    if (sGetBooleanWithDefault == null) {
                        sGetBooleanWithDefault = SYSTEM_PROPERTIES_CLASS.getDeclaredMethod("getBoolean", new Class[]{String.class, boolean.class});
                        sGetBooleanWithDefault.setAccessible(true);
                    }
                }
            }

            Object value = sGetBooleanWithDefault.invoke(SYSTEM_PROPERTIES_CLASS, key, def);
            if (value == null) {
                return def;
            }
            return (Boolean) value;
        } catch (Exception e) {
        }
        return def;
    }

    public static int getInt(String key, int def) {
        try {
            if (sGetIntegerWithDefault == null) {
                synchronized (SystemPropertiesReflector.class) {
                    if (sGetIntegerWithDefault == null) {
                        sGetIntegerWithDefault = SYSTEM_PROPERTIES_CLASS.getDeclaredMethod("getInt", new Class[]{String.class, int.class});
                        sGetIntegerWithDefault.setAccessible(true);
                    }
                }
            }

            Object value = sGetIntegerWithDefault.invoke(SYSTEM_PROPERTIES_CLASS, key, def);
            if (value == null) {
                return def;
            }
            return (Integer) value;
        } catch (Exception e) {
        }
        return def;
    }
}
