/*
 * Decompiled with CFR 0.152.
 */
package cn.kw.lib.common;

import cn.kw.lib.common.IO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;

public final class Text {
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static byte[] bytes(String s) {
        if (Text.empty(s)) {
            return null;
        }
        return s.getBytes(UTF_8);
    }

    public static boolean empty(String s) {
        return null == s || s.length() <= 0;
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (null == s1 && null == s2) {
            return true;
        }
        if (null != s1 && null != s2) {
            return s1.equalsIgnoreCase(s2);
        }
        return false;
    }

    public static boolean equals(String s1, String s2) {
        if (null == s1 && null == s2) {
            return true;
        }
        if (null != s1 && null != s2) {
            return s1.equals(s2);
        }
        return false;
    }

    public static boolean contains(String s, String sub) {
        if (null == s && null == sub) {
            return true;
        }
        if (null != s && null != sub) {
            return s.contains(sub);
        }
        return false;
    }

    public static String timeMillis(long millis) {
        return new Date(millis).toLocaleString();
    }

    public static void writeTo(String s, File file) throws IOException {
        if (file == null) {
            throw new IOException("Target File Can not be null in Text.writeTo");
        }
        File var2 = file.getParentFile();
        if (!var2.exists()) {
            var2.mkdirs();
        }
        FileWriter var3 = new FileWriter(file);
        var3.write(s);
        var3.close();
    }

    public static String readFileAsString(String fileName) {
        return Text.readFileAsString(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (Exception exception) {
            IO.closeQuietly(in);
        }
        catch (Throwable throwable) {
            IO.closeQuietly(in);
            throw throwable;
        }
        IO.closeQuietly(in);
        return stringBuilder.toString();
    }

    public static int parseInteger(String integer, int errorInteger) {
        try {
            return Integer.parseInt(integer);
        }
        catch (Throwable e) {
            return errorInteger;
        }
    }
}

